/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.document.view;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.resources.Images;
import ancestris.modules.document.view.AbstractDocumentView;
import ancestris.modules.document.view.FopDocumentView;
import ancestris.util.Utilities;
import ancestris.util.swing.FileChooserBuilder;
import ancestris.util.swing.svg.SvgDisplay;
import genj.fo.Format;
import genj.gedcom.Context;
import genj.io.FileAssociation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.fop.svg.PDFTranscoder;
import org.openide.util.NbBundle;

public class SvgDocumentView
extends AbstractDocumentView {
    private final File fichier;
    private JSlider jZoom;
    private final SvgDisplay jSvg;
    private boolean allowPdf = true;

    public SvgDocumentView(File file, Context context, String title, String tooltip) {
        super(context, title, tooltip);
        this.fichier = file;
        this.jSvg = new SvgDisplay(this.fichier);
        this.setView((JComponent)this.jSvg);
    }

    @Override
    protected void setToolbar() {
        Component oldTb = ((BorderLayout)this.getLayout()).getLayoutComponent("West");
        if (oldTb != null) {
            this.remove(oldTb);
        }
        JToolBar toolbar = new JToolBar(1);
        toolbar.add((Action)((Object)new ActionSave()));
        toolbar.setFloatable(false);
        this.jZoom = new JSlider(1, 500, 100);
        this.jZoom.setOrientation(1);
        this.jZoom.addChangeListener(evt -> this.jZoomStateChanged(evt));
        toolbar.add(this.jZoom);
        this.add((Component)toolbar, "West");
        this.validate();
    }

    private void jZoomStateChanged(ChangeEvent evt) {
        this.jSvg.setScale(0.01 * (double)this.jZoom.getValue());
        this.jSvg.updateUI();
        this.setPreferredSize(this.jSvg.getPreferredSize());
        this.updateUI();
        this.revalidate();
        this.repaint();
    }

    public void calculateDefaultSize() {
        Dimension currentDim = this.getSize();
        Dimension svgDim = this.jSvg.getPreferredSize();
        if (svgDim.height > 19000 || svgDim.width > 19000) {
            this.allowPdf = false;
        }
        double width = currentDim.getWidth() / svgDim.getWidth();
        double height = currentDim.getHeight() / svgDim.getHeight();
        double scale = Math.max(width, height) * 100.0 - 4.0;
        this.jZoom.setValue((int)scale);
    }

    private class ActionSave
    extends AbstractAncestrisAction {
        protected ActionSave() {
            this.setImage((Icon)Images.imgSave);
            this.setTip(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_SaveDocument", (Object)""));
        }

        public void actionPerformed(ActionEvent event) {
            File file;
            block27: {
                Format[] formats = Format.getFormats();
                TreeMap<String, String> fmts = new TreeMap<String, String>();
                fmts.put(FileChooserBuilder.getImageFilter().getExtensions()[0], FileChooserBuilder.getImageFilter().getExtensions()[0]);
                fmts.put(FileChooserBuilder.getImageFilter().getExtensions()[6], FileChooserBuilder.getImageFilter().getExtensions()[6]);
                if (SvgDocumentView.this.allowPdf) {
                    fmts.put(FileChooserBuilder.getPdfFilter().getExtensions()[0], FileChooserBuilder.getPdfFilter().getExtensions()[0]);
                }
                String fileName = Utilities.removeDiacriticsUnderscore((String)SvgDocumentView.this.getName());
                File f = new File(fileName);
                FileChooserBuilder fcb = new FileChooserBuilder(FopDocumentView.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_SaveDocument", (Object)SvgDocumentView.this.getName())).setApproveText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"OK_Button")).setDefaultExtension(formats[0].getFileExtension()).setFileFilters(fmts).setAcceptAllFileFilterUsed(false).setDefaultDirAsReportDirectory().setSelectedFile(f).setFileHiding(true);
                file = fcb.showSaveDialog();
                if (file == null) {
                    return;
                }
                try {
                    file.getParentFile().mkdirs();
                    if (file.getName().endsWith(".svg")) {
                        Files.copy(SvgDocumentView.this.fichier.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        break block27;
                    }
                    if (file.getName().endsWith(".pdf")) {
                        try (FileOutputStream pdfOstream = new FileOutputStream(file);
                             FileInputStream svgInputStream = new FileInputStream(SvgDocumentView.this.fichier);){
                            TranscoderInput tInput = new TranscoderInput((InputStream)svgInputStream);
                            TranscoderOutput outputPdfFile = new TranscoderOutput((OutputStream)pdfOstream);
                            PDFTranscoder transcoder = new PDFTranscoder();
                            transcoder.transcode(tInput, outputPdfFile);
                            pdfOstream.flush();
                            break block27;
                        }
                        catch (IOException | TranscoderException e) {
                            Logger.getLogger("ancestris.modules.document.view").log(Level.INFO, "cannot convert" + file, e);
                        }
                        break block27;
                    }
                    if (!file.getName().endsWith(".png")) break block27;
                    try (FileOutputStream pngOstream = new FileOutputStream(file);){
                        BufferedImage image = SvgDocumentView.this.jSvg.getImageDefaultSize();
                        ImageIO.write((RenderedImage)image, "png", pngOstream);
                    }
                    catch (IOException e) {
                        Logger.getLogger("ancestris.modules.document.view").log(Level.INFO, "cannot convert" + file, e);
                    }
                }
                catch (IOException e) {
                    Logger.getLogger("ancestris.modules.document.view").log(Level.INFO, "cannot copy" + file, e);
                }
            }
            try {
                FileAssociation.getDefault().execute(file.getAbsolutePath());
            }
            catch (Throwable t) {
                Logger.getLogger("ancestris.modules.document.view").log(Level.INFO, "cannot open " + file, t);
            }
        }
    }
}

