/* ADCD - A Diminutive CD player for Linux/GNU
   Copyright (C) 2004-2026 Antonio Diaz Diaz.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

class Msf_time			// Non-negative time (instant or duration)
  {
  enum { fps = 75 };		// Frames per second
  int minute_, second_, frame_;

public:
  Msf_time() : minute_( 0 ), second_( 0 ), frame_( 0 ) {}
  explicit Msf_time( const int m, const int s = 0, const int f = 0 );

  void reset() { minute_ = second_ = frame_ = 0; }

  Msf_time & operator+=( const Msf_time & a );
  Msf_time & operator-=( const Msf_time & a );
  Msf_time operator+( const Msf_time & a ) const
    { Msf_time r( *this ); r += a; return r; }
  Msf_time operator-( const Msf_time & a ) const
    { Msf_time r( *this ); r -= a; return r; }
  bool operator<( const Msf_time & a ) const;
  bool operator>( const Msf_time & a ) const;
  bool operator<=( const Msf_time & a ) const { return !(*this > a); }
  bool operator>=( const Msf_time & a ) const { return !(*this < a); }

  int minute() const { return minute_; }
  int second() const { return second_; }
  int frame() const { return frame_; }
  };
