/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.gdip.RectF;
import org.eclipse.swt.internal.win32.OS;

public class Path
extends Resource {
    public long handle;
    PointF currentPoint = new PointF();
    PointF startPoint = new PointF();

    public Path(Device device) {
        super(device);
        this.device.checkGDIP();
        this.handle = Gdip.GraphicsPath_new(0);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    public Path(Device device, Path path2, float flatness) {
        super(device);
        if (path2 == null) {
            SWT.error(4);
        }
        if (path2.isDisposed()) {
            SWT.error(5);
        }
        flatness = Math.max(0.0f, flatness);
        this.handle = Gdip.GraphicsPath_Clone(path2.handle);
        if (flatness != 0.0f) {
            Gdip.GraphicsPath_Flatten(this.handle, 0L, flatness);
        }
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    public Path(Device device, PathData data2) {
        this(device);
        if (data2 == null) {
            SWT.error(4);
        }
        this.init(data2);
    }

    public void addArc(float x2, float y2, float width, float height, float startAngle, float arcAngle) {
        x2 = DPIUtil.autoScaleUp(x2);
        y2 = DPIUtil.autoScaleUp(y2);
        width = DPIUtil.autoScaleUp(width);
        height = DPIUtil.autoScaleUp(height);
        this.addArcInPixels(x2, y2, width, height, startAngle, arcAngle);
    }

    void addArcInPixels(float x2, float y2, float width, float height, float startAngle, float arcAngle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0.0f) {
            x2 += width;
            width = -width;
        }
        if (height < 0.0f) {
            y2 += height;
            height = -height;
        }
        if (width == 0.0f || height == 0.0f || arcAngle == 0.0f) {
            return;
        }
        if (width == height) {
            Gdip.GraphicsPath_AddArc(this.handle, x2, y2, width, height, -startAngle, -arcAngle);
        } else {
            long matrix;
            long path2 = Gdip.GraphicsPath_new(0);
            if (path2 == 0L) {
                SWT.error(2);
            }
            if ((matrix = Gdip.Matrix_new(width, 0.0f, 0.0f, height, x2, y2)) == 0L) {
                SWT.error(2);
            }
            Gdip.GraphicsPath_AddArc(path2, 0.0f, 0.0f, 1.0f, 1.0f, -startAngle, -arcAngle);
            Gdip.GraphicsPath_Transform(path2, matrix);
            Gdip.GraphicsPath_AddPath(this.handle, path2, true);
            Gdip.Matrix_delete(matrix);
            Gdip.GraphicsPath_delete(path2);
        }
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public void addPath(Path path2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path2 == null) {
            SWT.error(4);
        }
        if (path2.isDisposed()) {
            SWT.error(5);
        }
        Gdip.GraphicsPath_AddPath(this.handle, path2.handle, false);
        this.currentPoint.X = path2.currentPoint.X;
        this.currentPoint.Y = path2.currentPoint.Y;
    }

    public void addRectangle(float x2, float y2, float width, float height) {
        x2 = DPIUtil.autoScaleUp(x2);
        y2 = DPIUtil.autoScaleUp(y2);
        width = DPIUtil.autoScaleUp(width);
        height = DPIUtil.autoScaleUp(height);
        this.addRectangleInPixels(x2, y2, width, height);
    }

    void addRectangleInPixels(float x2, float y2, float width, float height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        RectF rect = new RectF();
        rect.X = x2;
        rect.Y = y2;
        rect.Width = width;
        rect.Height = height;
        Gdip.GraphicsPath_AddRectangle(this.handle, rect);
        this.currentPoint.X = x2;
        this.currentPoint.Y = y2;
    }

    public void addString(String string2, float x2, float y2, Font font) {
        x2 = DPIUtil.autoScaleUp(x2);
        y2 = DPIUtil.autoScaleUp(y2);
        this.addStringInPixels(string2, x2, y2, font);
    }

    void addStringInPixels(String string2, float x2, float y2, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        char[] buffer = string2.toCharArray();
        long hDC = this.device.internal_new_GC(null);
        long[] family = new long[1];
        long gdipFont = GC.createGdipFont(hDC, font.handle, 0L, this.device.fontCollection, family, null);
        PointF point = new PointF();
        point.X = x2 - Gdip.Font_GetSize(gdipFont) / 6.0f;
        point.Y = y2;
        int style = Gdip.Font_GetStyle(gdipFont);
        float size = Gdip.Font_GetSize(gdipFont);
        Gdip.GraphicsPath_AddString(this.handle, buffer, buffer.length, family[0], style, size, point, 0L);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
        Gdip.FontFamily_delete(family[0]);
        Gdip.Font_delete(gdipFont);
        this.device.internal_dispose_GC(hDC, null);
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_CloseFigure(this.handle);
        this.currentPoint.X = this.startPoint.X;
        this.currentPoint.Y = this.startPoint.Y;
    }

    public boolean contains(float x2, float y2, GC gc, boolean outline) {
        x2 = DPIUtil.autoScaleUp(x2);
        y2 = DPIUtil.autoScaleUp(y2);
        return this.containsInPixels(x2, y2, gc, outline);
    }

    boolean containsInPixels(float x2, float y2, GC gc, boolean outline) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        gc.initGdip();
        gc.checkGC(120);
        int mode = OS.GetPolyFillMode(gc.handle) == 2 ? 1 : 0;
        Gdip.GraphicsPath_SetFillMode(this.handle, mode);
        if (outline) {
            return Gdip.GraphicsPath_IsOutlineVisible(this.handle, x2, y2, gc.data.gdipPen, gc.data.gdipGraphics);
        }
        return Gdip.GraphicsPath_IsVisible(this.handle, x2, y2, gc.data.gdipGraphics);
    }

    public void cubicTo(float cx1, float cy1, float cx2, float cy2, float x2, float y2) {
        cx1 = DPIUtil.autoScaleUp(cx1);
        cy1 = DPIUtil.autoScaleUp(cy1);
        cx2 = DPIUtil.autoScaleUp(cx2);
        cy2 = DPIUtil.autoScaleUp(cy2);
        x2 = DPIUtil.autoScaleUp(x2);
        y2 = DPIUtil.autoScaleUp(y2);
        this.cubicToInPixels(cx1, cy1, cx2, cy2, x2, y2);
    }

    void cubicToInPixels(float cx1, float cy1, float cx2, float cy2, float x2, float y2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_AddBezier(this.handle, this.currentPoint.X, this.currentPoint.Y, cx1, cy1, cx2, cy2, x2, y2);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    @Override
    void destroy() {
        Gdip.GraphicsPath_delete(this.handle);
        this.handle = 0L;
    }

    public void getBounds(float[] bounds) {
        if (bounds == null) {
            SWT.error(4);
        }
        this.getBoundsInPixels(bounds);
        bounds = DPIUtil.autoScaleDown(bounds);
    }

    void getBoundsInPixels(float[] bounds) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (bounds.length < 4) {
            SWT.error(5);
        }
        RectF rect = new RectF();
        Gdip.GraphicsPath_GetBounds(this.handle, rect, 0L, 0L);
        bounds[0] = rect.X;
        bounds[1] = rect.Y;
        bounds[2] = rect.Width;
        bounds[3] = rect.Height;
    }

    public void getCurrentPoint(float[] point) {
        if (point == null) {
            SWT.error(4);
        }
        this.getCurrentPointInPixels(point);
        point = DPIUtil.autoScaleDown(point);
    }

    void getCurrentPointInPixels(float[] point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point.length < 2) {
            SWT.error(5);
        }
        point[0] = this.currentPoint.X;
        point[1] = this.currentPoint.Y;
    }

    public PathData getPathData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        PathData result2 = this.getPathDataInPixels();
        result2.points = DPIUtil.autoScaleDown(result2.points);
        return result2;
    }

    PathData getPathDataInPixels() {
        int count = Gdip.GraphicsPath_GetPointCount(this.handle);
        byte[] gdipTypes = new byte[count];
        float[] points = new float[count * 2];
        Gdip.GraphicsPath_GetPathTypes(this.handle, gdipTypes, count);
        Gdip.GraphicsPath_GetPathPoints(this.handle, points, count);
        byte[] types = new byte[count * 2];
        int index = 0;
        int typesIndex = 0;
        while (index < count) {
            byte type2 = gdipTypes[index];
            boolean close = false;
            switch (type2 & 7) {
                case 0: {
                    types[typesIndex++] = 1;
                    close = (type2 & 0x80) != 0;
                    ++index;
                    break;
                }
                case 1: {
                    types[typesIndex++] = 2;
                    close = (type2 & 0x80) != 0;
                    ++index;
                    break;
                }
                case 3: {
                    types[typesIndex++] = 4;
                    close = (gdipTypes[index + 2] & 0x80) != 0;
                    index += 3;
                    break;
                }
                default: {
                    ++index;
                }
            }
            if (!close) continue;
            types[typesIndex++] = 5;
        }
        if (typesIndex != types.length) {
            byte[] newTypes = new byte[typesIndex];
            System.arraycopy(types, 0, newTypes, 0, typesIndex);
            types = newTypes;
        }
        PathData result2 = new PathData();
        result2.types = types;
        result2.points = points;
        return result2;
    }

    public void lineTo(float x2, float y2) {
        this.lineToInPixels(DPIUtil.autoScaleUp(x2), DPIUtil.autoScaleUp(y2));
    }

    void lineToInPixels(float x2, float y2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_AddLine(this.handle, this.currentPoint.X, this.currentPoint.Y, x2, y2);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    void init(PathData data2) {
        byte[] types = data2.types;
        float[] points = data2.points;
        int i2 = 0;
        int j2 = 0;
        while (i2 < types.length) {
            switch (types[i2]) {
                case 1: {
                    this.moveTo(points[j2++], points[j2++]);
                    break;
                }
                case 2: {
                    this.lineTo(points[j2++], points[j2++]);
                    break;
                }
                case 4: {
                    this.cubicTo(points[j2++], points[j2++], points[j2++], points[j2++], points[j2++], points[j2++]);
                    break;
                }
                case 3: {
                    this.quadTo(points[j2++], points[j2++], points[j2++], points[j2++]);
                    break;
                }
                case 5: {
                    this.close();
                    break;
                }
                default: {
                    this.dispose();
                    SWT.error(5);
                }
            }
            ++i2;
        }
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public void moveTo(float x2, float y2) {
        this.moveToInPixels(DPIUtil.autoScaleUp(x2), DPIUtil.autoScaleUp(y2));
    }

    void moveToInPixels(float x2, float y2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_StartFigure(this.handle);
        this.currentPoint.X = this.startPoint.X = x2;
        this.currentPoint.Y = this.startPoint.Y = y2;
    }

    public void quadTo(float cx, float cy, float x2, float y2) {
        cx = DPIUtil.autoScaleUp(cx);
        cy = DPIUtil.autoScaleUp(cy);
        x2 = DPIUtil.autoScaleUp(x2);
        y2 = DPIUtil.autoScaleUp(y2);
        this.quadToInPixels(cx, cy, x2, y2);
    }

    void quadToInPixels(float cx, float cy, float x2, float y2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        float cx1 = this.currentPoint.X + 2.0f * (cx - this.currentPoint.X) / 3.0f;
        float cy1 = this.currentPoint.Y + 2.0f * (cy - this.currentPoint.Y) / 3.0f;
        float cx2 = cx1 + (x2 - this.currentPoint.X) / 3.0f;
        float cy2 = cy1 + (y2 - this.currentPoint.Y) / 3.0f;
        Gdip.GraphicsPath_AddBezier(this.handle, this.currentPoint.X, this.currentPoint.Y, cx1, cy1, cx2, cy2, x2, y2);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

