/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.webkit.IWebDownload;
import org.eclipse.swt.internal.webkit.IWebMutableURLRequest;
import org.eclipse.swt.internal.webkit.IWebURLResponse;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

class WebDownloadDelegate {
    COMObject iWebDownloadDelegate;
    Browser browser;
    int refCount = 0;
    int status = -1;
    long size;
    long totalSize;
    String url;
    static final int DOWNLOAD_FINISHED = 0;
    static final int DOWNLOAD_CANCELLED = 1;
    static final int DOWNLOAD_ERROR = 3;

    WebDownloadDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[15];
        nArray[0] = 2;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 2;
        nArray[9] = 2;
        nArray[10] = 3;
        nArray[11] = 3;
        nArray[12] = 4;
        nArray[13] = 1;
        nArray[14] = 1;
        this.iWebDownloadDelegate = new COMObject(nArray){

            @Override
            public long method0(long[] args2) {
                return WebDownloadDelegate.this.QueryInterface(args2[0], args2[1]);
            }

            @Override
            public long method1(long[] args2) {
                return WebDownloadDelegate.this.AddRef();
            }

            @Override
            public long method2(long[] args2) {
                return WebDownloadDelegate.this.Release();
            }

            @Override
            public long method3(long[] args2) {
                return WebDownloadDelegate.this.decideDestinationWithSuggestedFilename(args2[0], args2[1]);
            }

            @Override
            public long method4(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method5(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method6(long[] args2) {
                return WebDownloadDelegate.this.didFailWithError(args2[0], args2[1]);
            }

            @Override
            public long method7(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method8(long[] args2) {
                return WebDownloadDelegate.this.didReceiveDataOfLength(args2[0], (int)args2[1]);
            }

            @Override
            public long method9(long[] args2) {
                return WebDownloadDelegate.this.didReceiveResponse(args2[0], args2[1]);
            }

            @Override
            public long method10(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method11(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method12(long[] args2) {
                return WebDownloadDelegate.this.willSendRequest(args2[0], args2[1], args2[2], args2[3]);
            }

            @Override
            public long method13(long[] args2) {
                return WebDownloadDelegate.this.didBegin(args2[0]);
            }

            @Override
            public long method14(long[] args2) {
                return WebDownloadDelegate.this.didFinish(args2[0]);
            }
        };
    }

    int decideDestinationWithSuggestedFilename(long download2, long filename) {
        String name = WebKit.extractBSTR(filename);
        FileDialog dialog2 = new FileDialog(this.browser.getShell(), 8192);
        dialog2.setText(SWT.getMessage("SWT_FileDownload"));
        dialog2.setFileName(name);
        dialog2.setOverwrite(true);
        String path2 = dialog2.open();
        IWebDownload iwebdownload = new IWebDownload(download2);
        iwebdownload.setDeletesFileUponFailure(0);
        if (path2 == null) {
            iwebdownload.setDestination(WebKit.createBSTR(""), 1);
            iwebdownload.cancel();
            iwebdownload.Release();
        } else {
            File file = new File(path2);
            if (file.exists()) {
                file.delete();
            }
            iwebdownload.setDestination(WebKit.createBSTR(path2), 1);
            this.openDownloadWindow(iwebdownload, path2);
        }
        return 0;
    }

    int didBegin(long download2) {
        new IWebDownload(download2).AddRef();
        this.status = -1;
        this.size = 0L;
        this.totalSize = 0L;
        this.url = null;
        return 0;
    }

    int didFailWithError(long download2, long error2) {
        new IWebDownload(download2).Release();
        this.status = 3;
        return 0;
    }

    int didFinish(long download2) {
        new IWebDownload(download2).Release();
        this.status = 0;
        return 0;
    }

    int didReceiveDataOfLength(long download2, int length) {
        this.size += (long)length;
        return 0;
    }

    int didReceiveResponse(long download2, long response) {
        if (response != 0L) {
            long[] result2;
            IWebURLResponse urlResponse = new IWebURLResponse(response);
            long[] size = new long[1];
            int hr = urlResponse.expectedContentLength(size);
            if (hr == 0) {
                this.totalSize = size[0];
            }
            if ((hr = urlResponse.URL(result2 = new long[1])) == 0 && result2[0] != 0L) {
                this.url = WebKit.extractBSTR(result2[0]);
                COM.SysFreeString(result2[0]);
            }
        }
        return 0;
    }

    void disposeCOMInterfaces() {
        if (this.iWebDownloadDelegate != null) {
            this.iWebDownloadDelegate.dispose();
            this.iWebDownloadDelegate = null;
        }
    }

    long getAddress() {
        return this.iWebDownloadDelegate.getAddress();
    }

    void openDownloadWindow(IWebDownload download2, String name) {
        final Shell shell = new Shell();
        shell.setText(Compatibility.getMessage("SWT_FileDownload"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        gridLayout.verticalSpacing = 20;
        shell.setLayout(gridLayout);
        Label nameLabel = new Label(shell, 64);
        nameLabel.setText(Compatibility.getMessage("SWT_Download_Location", new Object[]{name, this.url}));
        GridData data2 = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int maxWidth = monitor.getBounds().width / 2;
        int width = nameLabel.computeSize((int)-1, (int)-1).x;
        data2.widthHint = Math.min(width, maxWidth);
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        nameLabel.setLayoutData(data2);
        final Label statusLabel = new Label(shell, 0);
        statusLabel.setText(Compatibility.getMessage("SWT_Download_Started"));
        data2 = new GridData(1808);
        statusLabel.setLayoutData(data2);
        final Button cancel = new Button(shell, 8);
        cancel.setText(Compatibility.getMessage("SWT_Cancel"));
        data2 = new GridData();
        data2.horizontalAlignment = 2;
        cancel.setLayoutData(data2);
        final Listener cancelListener = event -> {
            download2.cancel();
            this.status = 1;
            download2.Release();
        };
        cancel.addListener(13, cancelListener);
        final Display display = this.browser.getDisplay();
        display.timerExec(500, new Runnable(){

            @Override
            public void run() {
                if (shell.isDisposed() || WebDownloadDelegate.this.status == 0 || WebDownloadDelegate.this.status == 1) {
                    shell.dispose();
                    return;
                }
                if (WebDownloadDelegate.this.status == 3) {
                    statusLabel.setText(Compatibility.getMessage("SWT_Download_Error"));
                    cancel.removeListener(13, cancelListener);
                    cancel.addListener(13, event -> shell.dispose());
                    return;
                }
                long current = WebDownloadDelegate.this.size / 1024L;
                long total = WebDownloadDelegate.this.totalSize / 1024L;
                String message2 = Compatibility.getMessage("SWT_Download_Status", new Object[]{current, total});
                statusLabel.setText(message2);
                display.timerExec(500, this);
            }
        });
        shell.pack();
        shell.open();
    }

    int QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147024809;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, riid, GUID.sizeof);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown)) {
            OS.MoveMemory(ppvObject, new long[]{this.iWebDownloadDelegate.getAddress()}, C.PTR_SIZEOF);
            new IUnknown(this.iWebDownloadDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(guid, WebKit_win32.IID_IWebDownloadDelegate)) {
            OS.MoveMemory(ppvObject, new long[]{this.iWebDownloadDelegate.getAddress()}, C.PTR_SIZEOF);
            new IUnknown(this.iWebDownloadDelegate.getAddress()).AddRef();
            return 0;
        }
        OS.MoveMemory(ppvObject, new long[1], C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int willSendRequest(long download2, long request, long redirectResponse, long finalRequest) {
        IWebMutableURLRequest req = new IWebMutableURLRequest(request);
        req.AddRef();
        OS.MoveMemory(finalRequest, new long[]{request}, C.PTR_SIZEOF);
        return 0;
    }
}

