/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.voice;

import de.treichels.hott.voice.ADPCMCodec;
import de.treichels.hott.voice.ObservableBase;
import de.treichels.hott.voice.Player;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001a\u001a\u00020\u0000J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\u0004H\u0016J\u000e\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020&R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u0018\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016\u00a8\u0006*"}, d2={"Lde/treichels/hott/voice/VoiceData;", "Ljava/io/Serializable;", "Lde/treichels/hott/voice/ObservableBase;", "name", "", "rawData", "", "(Ljava/lang/String;[B)V", "audioInputStream", "Ljavax/sound/sampled/AudioInputStream;", "getAudioInputStream", "()Ljavax/sound/sampled/AudioInputStream;", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "pcmData", "getPcmData", "()[B", "pcmInputStream", "Ljava/io/InputStream;", "getPcmInputStream", "()Ljava/io/InputStream;", "getRawData", "rawInputStream", "getRawInputStream", "clone", "equals", "", "other", "", "hashCode", "", "play", "", "toString", "writeVox", "voxFile", "Ljava/io/File;", "writeWav", "wavFile", "Companion", "HoTT-Voice"})
public final class VoiceData
extends ObservableBase
implements Serializable {
    @NotNull
    private String name;
    @NotNull
    private final byte[] rawData;
    private static final AudioFormat audioFormat;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String name) {
        String string2;
        Intrinsics.checkNotNullParameter(name, "name");
        if (name.length() > 17) {
            String string3 = name;
            int n2 = 0;
            int n3 = 18;
            boolean bl = false;
            String string4 = string3.substring(n2, n3);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string2 = name;
        }
        this.name = string2;
        this.invalidate();
    }

    @NotNull
    public final AudioInputStream getAudioInputStream() {
        return new AudioInputStream(this.getPcmInputStream(), audioFormat, 2L * (long)this.rawData.length);
    }

    @NotNull
    public final byte[] getPcmData() {
        return ADPCMCodec.Companion.decode(this.rawData);
    }

    @NotNull
    public final InputStream getPcmInputStream() {
        return ADPCMCodec.Companion.decode(this.getRawInputStream());
    }

    @NotNull
    public final InputStream getRawInputStream() {
        return new ByteArrayInputStream(this.rawData);
    }

    public final void play() {
        try {
            Player.play$default(Player.INSTANCE, audioFormat, this.getPcmInputStream(), false, 4, null);
        }
        catch (LineUnavailableException e2) {
            throw (Throwable)new RuntimeException(e2);
        }
        catch (IOException e3) {
            throw (Throwable)new RuntimeException(e3);
        }
    }

    @NotNull
    public String toString() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "VoiceData [name=%s]";
        Object[] objectArray = new Object[]{this.name};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(format, *args)");
        return string3;
    }

    public final void writeVox(@NotNull File voxFile) {
        Intrinsics.checkNotNullParameter(voxFile, "voxFile");
        Files.write(voxFile.toPath(), this.rawData, new OpenOption[0]);
    }

    public final void writeWav(@NotNull File wavFile) {
        Intrinsics.checkNotNullParameter(wavFile, "wavFile");
        AudioSystem.write(this.getAudioInputStream(), AudioFileFormat.Type.WAVE, wavFile);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type de.treichels.hott.voice.VoiceData");
        }
        VoiceData cfr_ignored_0 = (VoiceData)object2;
        if (!Arrays.equals(this.rawData, ((VoiceData)other).rawData)) {
            return false;
        }
        return !(Intrinsics.areEqual(this.name, ((VoiceData)other).name) ^ true);
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.rawData);
        result2 = 31 * result2 + this.name.hashCode();
        return result2;
    }

    @NotNull
    public final VoiceData clone() {
        return new VoiceData(this.name, this.rawData);
    }

    @NotNull
    public final byte[] getRawData() {
        return this.rawData;
    }

    public VoiceData(@NotNull String name, @NotNull byte[] rawData) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(rawData, "rawData");
        this.rawData = rawData;
        this.name = name;
    }

    static {
        Companion = new Companion(null);
        audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 16, 1, 2, 11025.0f, false);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/treichels/hott/voice/VoiceData$Companion;", "", "()V", "audioFormat", "Ljavax/sound/sampled/AudioFormat;", "forFile", "Lde/treichels/hott/voice/VoiceData;", "soundFile", "Ljava/io/File;", "volume", "", "forStream", "sourceAudioStream", "Ljavax/sound/sampled/AudioInputStream;", "name", "", "HoTT-Voice"})
    public static final class Companion {
        @NotNull
        public final VoiceData forStream(@NotNull AudioInputStream sourceAudioStream, @NotNull String name, double volume) {
            AudioInputStream targetAudioStream;
            AudioFormat sourceFormat;
            Intrinsics.checkNotNullParameter(sourceAudioStream, "sourceAudioStream");
            Intrinsics.checkNotNullParameter(name, "name");
            AudioFormat audioFormat = sourceFormat = sourceAudioStream.getFormat();
            Intrinsics.checkNotNullExpressionValue(audioFormat, "sourceFormat");
            float rate = audioFormat.getSampleRate();
            int channels = sourceFormat.getChannels();
            AudioFormat pcmFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, rate, 16, channels, channels * 2, rate, false);
            AudioInputStream pcmAudioStream = sourceFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED ? sourceAudioStream : AudioSystem.getAudioInputStream(pcmFormat, sourceAudioStream);
            AudioInputStream audioInputStream = targetAudioStream = pcmFormat.matches(audioFormat) ? pcmAudioStream : AudioSystem.getAudioInputStream(audioFormat, pcmAudioStream);
            Intrinsics.checkNotNullExpressionValue(audioInputStream, "targetAudioStream");
            InputStream encodedStream = ADPCMCodec.Companion.encode(audioInputStream, volume);
            byte[] byArray = IOUtils.toByteArray(encodedStream);
            Intrinsics.checkNotNullExpressionValue(byArray, "IOUtils.toByteArray(encodedStream)");
            return new VoiceData(name, byArray);
        }

        public static /* synthetic */ VoiceData forStream$default(Companion companion, AudioInputStream audioInputStream, String string2, double d2, int n2, Object object) {
            if ((n2 & 4) != 0) {
                d2 = 1.0;
            }
            return companion.forStream(audioInputStream, string2, d2);
        }

        @NotNull
        public final VoiceData forFile(@NotNull File soundFile, double volume) {
            String fileName;
            Intrinsics.checkNotNullParameter(soundFile, "soundFile");
            AudioInputStream sourceAudioStream = AudioSystem.getAudioInputStream(soundFile);
            String string2 = fileName = soundFile.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "fileName");
            int dot = StringsKt.lastIndexOf$default((CharSequence)string2, ".", 0, false, 6, null);
            String string3 = fileName;
            int n2 = 0;
            boolean bl = false;
            String string4 = string3.substring(n2, dot);
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String name = string4;
            AudioInputStream audioInputStream = sourceAudioStream;
            Intrinsics.checkNotNullExpressionValue(audioInputStream, "sourceAudioStream");
            return this.forStream(audioInputStream, name, volume);
        }

        public static /* synthetic */ VoiceData forFile$default(Companion companion, File file, double d2, int n2, Object object) {
            if ((n2 & 2) != 0) {
                d2 = 1.0;
            }
            return companion.forFile(file, d2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

