/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jaxb.runtime.v2;

import com.sun.istack.FinalArrayList;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.glassfish.jaxb.core.Utils;
import org.glassfish.jaxb.core.v2.Messages;
import org.glassfish.jaxb.runtime.api.JAXBRIContext;
import org.glassfish.jaxb.runtime.api.TypeReference;
import org.glassfish.jaxb.runtime.v2.MUtils;
import org.glassfish.jaxb.runtime.v2.model.annotation.RuntimeAnnotationReader;
import org.glassfish.jaxb.runtime.v2.runtime.JAXBContextImpl;
import org.glassfish.jaxb.runtime.v2.util.TypeCast;

public class ContextFactory {
    public static final String USE_JAXB_PROPERTIES = "_useJAXBProperties";

    public static JAXBContext createContext(Class[] classes2, Map<String, Object> properties2) throws JAXBException {
        Map<Class, Class> subclassReplacements;
        Boolean xmlAccessorFactorySupport;
        Boolean improvedXsiTypeHandling;
        Boolean supressAccessorWarnings;
        Boolean retainPropertyInfo;
        Boolean allNillable;
        Boolean disablesecurityProcessing;
        MUtils.open(classes2);
        properties2 = properties2 == null ? Collections.emptyMap() : new HashMap<String, Object>(properties2);
        String defaultNsUri = ContextFactory.getPropertyValue(properties2, "org.glassfish.jaxb.defaultNamespaceRemap", String.class);
        Boolean c14nSupport = ContextFactory.getPropertyValue(properties2, "org.glassfish.jaxb.c14n", Boolean.class);
        if (c14nSupport == null) {
            c14nSupport = false;
        }
        if ((disablesecurityProcessing = ContextFactory.getPropertyValue(properties2, "org.glassfish.jaxb.disableXmlSecurity", Boolean.class)) == null) {
            disablesecurityProcessing = false;
        }
        if ((allNillable = ContextFactory.getPropertyValue(properties2, "org.glassfish.jaxb.treatEverythingNillable", Boolean.class)) == null) {
            allNillable = false;
        }
        if ((retainPropertyInfo = ContextFactory.getPropertyValue(properties2, "retainReferenceToInfo", Boolean.class)) == null) {
            retainPropertyInfo = false;
        }
        if ((supressAccessorWarnings = ContextFactory.getPropertyValue(properties2, "supressAccessorWarnings", Boolean.class)) == null) {
            supressAccessorWarnings = false;
        }
        if ((improvedXsiTypeHandling = ContextFactory.getPropertyValue(properties2, "org.glassfish.jaxb.improvedXsiTypeHandling", Boolean.class)) == null) {
            String improvedXsiSystemProperty = Utils.getSystemProperty("org.glassfish.jaxb.improvedXsiTypeHandling");
            improvedXsiTypeHandling = improvedXsiSystemProperty == null ? Boolean.valueOf(true) : Boolean.valueOf(improvedXsiSystemProperty);
        }
        if ((xmlAccessorFactorySupport = ContextFactory.getPropertyValue(properties2, "org.glassfish.jaxb.XmlAccessorFactory", Boolean.class)) == null) {
            xmlAccessorFactorySupport = false;
            Utils.getClassLogger().log(Level.FINE, "Property org.glassfish.jaxb.XmlAccessorFactoryis not active.  Using JAXB's implementation");
        }
        Boolean backupWithParentNamespace = ContextFactory.getPropertyValue(properties2, "org.glassfish.jaxb.backupWithParentNamespace", Boolean.class);
        RuntimeAnnotationReader ar = ContextFactory.getPropertyValue(properties2, JAXBRIContext.ANNOTATION_READER, RuntimeAnnotationReader.class);
        List<TypeReference> tr = ContextFactory.getPropertyValue(properties2, "org.glassfish.jaxb.typeReferences", Collection.class);
        if (tr == null) {
            tr = Collections.emptyList();
        }
        try {
            subclassReplacements = TypeCast.checkedCast(ContextFactory.getPropertyValue(properties2, "org.glassfish.jaxb.subclassReplacements", Map.class), Class.class, Class.class);
        }
        catch (ClassCastException e2) {
            throw new JAXBException(Messages.INVALID_TYPE_IN_MAP.format(new Object[0]), e2);
        }
        Integer maxErrorsCount = ContextFactory.getPropertyValue(properties2, "org.glassfish.jaxb.maxErrorsCount", Integer.class);
        if (maxErrorsCount == null) {
            maxErrorsCount = 10;
        } else if (maxErrorsCount < 0) {
            maxErrorsCount = Integer.MAX_VALUE;
        }
        if (!properties2.isEmpty()) {
            throw new JAXBException(Messages.UNSUPPORTED_PROPERTY.format(properties2.keySet().iterator().next()));
        }
        JAXBContextImpl.JAXBContextBuilder builder = new JAXBContextImpl.JAXBContextBuilder();
        builder.setClasses(classes2);
        builder.setTypeRefs(tr);
        builder.setSubclassReplacements(subclassReplacements);
        builder.setDefaultNsUri(defaultNsUri);
        builder.setC14NSupport(c14nSupport);
        builder.setAnnotationReader(ar);
        builder.setXmlAccessorFactorySupport(xmlAccessorFactorySupport);
        builder.setAllNillable(allNillable);
        builder.setRetainPropertyInfo(retainPropertyInfo);
        builder.setSupressAccessorWarnings(supressAccessorWarnings);
        builder.setImprovedXsiTypeHandling(improvedXsiTypeHandling);
        builder.setDisableSecurityProcessing(disablesecurityProcessing);
        builder.setBackupWithParentNamespace(backupWithParentNamespace);
        builder.setMaxErrorsCount(maxErrorsCount);
        return builder.build();
    }

    private static <T> T getPropertyValue(Map<String, Object> properties2, String keyName, Class<T> type2) throws JAXBException {
        Object o2 = properties2.get(keyName);
        if (o2 == null) {
            return null;
        }
        properties2.remove(keyName);
        if (!type2.isInstance(o2)) {
            throw new JAXBException(Messages.INVALID_PROPERTY_VALUE.format(keyName, o2));
        }
        return type2.cast(o2);
    }

    @Deprecated
    public static JAXBRIContext createContext(Class[] classes2, Collection<TypeReference> typeRefs, Map<Class, Class> subclassReplacements, String defaultNsUri, boolean c14nSupport, RuntimeAnnotationReader ar, boolean xmlAccessorFactorySupport, boolean allNillable, boolean retainPropertyInfo) throws JAXBException {
        return ContextFactory.createContext(classes2, typeRefs, subclassReplacements, defaultNsUri, c14nSupport, ar, xmlAccessorFactorySupport, allNillable, retainPropertyInfo, false);
    }

    @Deprecated
    public static JAXBRIContext createContext(Class[] classes2, Collection<TypeReference> typeRefs, Map<Class, Class> subclassReplacements, String defaultNsUri, boolean c14nSupport, RuntimeAnnotationReader ar, boolean xmlAccessorFactorySupport, boolean allNillable, boolean retainPropertyInfo, boolean improvedXsiTypeHandling) throws JAXBException {
        MUtils.open(classes2);
        JAXBContextImpl.JAXBContextBuilder builder = new JAXBContextImpl.JAXBContextBuilder();
        builder.setClasses(classes2);
        builder.setTypeRefs(typeRefs);
        builder.setSubclassReplacements(subclassReplacements);
        builder.setDefaultNsUri(defaultNsUri);
        builder.setC14NSupport(c14nSupport);
        builder.setAnnotationReader(ar);
        builder.setXmlAccessorFactorySupport(xmlAccessorFactorySupport);
        builder.setAllNillable(allNillable);
        builder.setRetainPropertyInfo(retainPropertyInfo);
        builder.setImprovedXsiTypeHandling(improvedXsiTypeHandling);
        return builder.build();
    }

    public static JAXBContext createContext(String contextPath, ClassLoader classLoader, Map<String, Object> properties2) throws JAXBException {
        FinalArrayList<Class> classes2 = new FinalArrayList<Class>();
        StringTokenizer tokens = new StringTokenizer(contextPath, ":");
        while (tokens.hasMoreTokens()) {
            List<Class> indexedClasses;
            boolean foundJaxbIndex = false;
            boolean foundObjectFactory = false;
            String pkg = tokens.nextToken();
            try {
                Class<?> o2 = classLoader.loadClass(pkg + ".ObjectFactory");
                classes2.add(o2);
                foundObjectFactory = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                indexedClasses = ContextFactory.loadIndexedClasses(pkg, classLoader);
            }
            catch (IOException e2) {
                throw new JAXBException(e2);
            }
            if (indexedClasses != null) {
                classes2.addAll(indexedClasses);
                foundJaxbIndex = true;
            }
            if (foundObjectFactory || foundJaxbIndex) continue;
            throw new JAXBException(Messages.BROKEN_CONTEXTPATH.format(pkg));
        }
        return ContextFactory.createContext(classes2.toArray(new Class[classes2.size()]), properties2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Class> loadIndexedClasses(String pkg, ClassLoader classLoader) throws IOException, JAXBException {
        String resource = pkg.replace('.', '/') + "/jaxb.index";
        InputStream resourceAsStream = classLoader.getResourceAsStream(resource);
        if (resourceAsStream == null) {
            return null;
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(resourceAsStream, "UTF-8"));){
            FinalArrayList<Class> classes2 = new FinalArrayList<Class>();
            String className = in.readLine();
            while (className != null) {
                if ((className = className.trim()).startsWith("#") || className.length() == 0) {
                    className = in.readLine();
                    continue;
                }
                if (className.endsWith(".class")) {
                    throw new JAXBException(Messages.ILLEGAL_ENTRY.format(className));
                }
                try {
                    classes2.add(classLoader.loadClass(pkg + '.' + className));
                }
                catch (ClassNotFoundException e2) {
                    throw new JAXBException(Messages.ERROR_LOADING_CLASS.format(className, resource), e2);
                }
                className = in.readLine();
            }
            FinalArrayList<Class> finalArrayList = classes2;
            return finalArrayList;
        }
    }
}

