/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.histo.datasources.HistoSet;
import gde.histo.recordings.SuiteRecords;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailSelector;
import gde.histo.ui.GraphicsComposite;
import gde.histo.utils.HistoTimeLine;
import gde.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Point;

public final class HistoGraphicsMapper {
    private static final String $CLASS_NAME = TrailSelector.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);

    public static List<PointArray> getSuiteDisplayPoints(GraphicsComposite.GraphicsLayout graphicsData, HistoTimeLine timeLine) {
        ArrayList<PointArray> suitePoints = new ArrayList<PointArray>();
        TrailRecord trailRecord = graphicsData.getTrailRecord();
        int firstOrdinal = trailRecord.getTrailSelector().getSuiteMasterIndex();
        for (int i = 0; i < timeLine.getScalePositions().size(); ++i) {
            if (trailRecord.getSuiteRecords().getSuiteValue(firstOrdinal, i) != null) {
                suitePoints.add(HistoGraphicsMapper.getSuiteDisplayPoints(graphicsData, timeLine, i));
                continue;
            }
            suitePoints.add(null);
        }
        return suitePoints;
    }

    private static PointArray getSuiteDisplayPoints(GraphicsComposite.GraphicsLayout graphicsData, HistoTimeLine timeLine, int index) {
        int x0 = timeLine.getCurveAreaBounds().x;
        int y0 = timeLine.getCurveAreaBounds().height + timeLine.getCurveAreaBounds().y;
        TrailRecord trailRecord = graphicsData.getTrailRecord();
        int suiteSize = trailRecord.getTrailSelector().getSuiteMembers().size();
        PointArray pointArray = new PointArray(suiteSize);
        pointArray.setX(x0 + timeLine.getScalePositions().get((long)trailRecord.getParent().getTime_ms(index)));
        double yOffset = HistoGraphicsMapper.getYOffset(graphicsData);
        SuiteRecords suiteRecords = trailRecord.getSuiteRecords();
        for (int j = 0; j < suiteSize; ++j) {
            Integer value = suiteRecords.getSuiteValue(j, index);
            if (value == null) continue;
            double decodedValue = HistoSet.decodeVaultValue(trailRecord.getChannelItem(), (double)value.intValue() / 1000.0);
            pointArray.setY(j, y0 - (int)((decodedValue - yOffset) * graphicsData.getDisplayScaleFactorValue()));
        }
        log.finer(() -> pointArray.toString());
        return pointArray;
    }

    public static Point[] getDisplayPoints(GraphicsComposite.GraphicsLayout graphicsData, HistoTimeLine timeLine) {
        TrailRecord trailRecord = graphicsData.getTrailRecord();
        int x0 = timeLine.getCurveAreaBounds().x;
        int y0 = timeLine.getCurveAreaBounds().height + timeLine.getCurveAreaBounds().y;
        double yOffset = HistoGraphicsMapper.getYOffset(graphicsData);
        Point[] points = new Point[trailRecord.realSize()];
        for (int i = 0; i < trailRecord.realSize(); ++i) {
            Integer value = (Integer)trailRecord.elementAt(i);
            if (value == null) continue;
            double decodedValue = HistoSet.decodeVaultValue(trailRecord.getChannelItem(), (double)value.intValue() / 1000.0);
            points[i] = new Point(x0 + timeLine.getScalePositions().get((long)trailRecord.getParent().getTime_ms(i)), y0 - (int)((decodedValue - yOffset) * graphicsData.getDisplayScaleFactorValue()));
        }
        log.finer(() -> Arrays.toString(points));
        return points;
    }

    public static int getVerticalDisplayPos(GraphicsComposite.GraphicsLayout graphicsData, int height, int index) {
        int verticalDisplayPos = Integer.MIN_VALUE;
        TrailRecord record = graphicsData.getTrailRecord();
        Integer value = record.getPoints().elementAt(index);
        if (value != null) {
            double decodedValue = HistoSet.decodeVaultValue(record.getChannelItem(), (double)value.intValue() / 1000.0);
            verticalDisplayPos = height - (int)((decodedValue - HistoGraphicsMapper.getYOffset(graphicsData)) * graphicsData.getDisplayScaleFactorValue());
        }
        return verticalDisplayPos;
    }

    public static int getVerticalDisplayPos(GraphicsComposite.GraphicsLayout graphicsData, int height, double decodedValue) {
        int verticalDisplayPos = height - (int)((decodedValue - HistoGraphicsMapper.getYOffset(graphicsData)) * graphicsData.getDisplayScaleFactorValue());
        log.finer(() -> String.format("translatedValue=%f yPos=%d", decodedValue, verticalDisplayPos));
        return verticalDisplayPos;
    }

    private static double getYOffset(GraphicsComposite.GraphicsLayout graphicsData) {
        return graphicsData.getMinDisplayValue() * 1.0 / graphicsData.getSyncMasterFactor();
    }

    public static final class PointArray {
        private int x;
        private final Integer[] y;

        public PointArray(int ySize) {
            this.y = new Integer[ySize];
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public Integer[] getY() {
            return this.y;
        }

        public void setY(int index, Integer value) {
            this.y[index] = value;
        }

        public Integer getY(int suiteOrdinal) {
            return this.getY()[suiteOrdinal];
        }

        public String toString() {
            return "PointArray [x=" + this.x + ", y=" + Arrays.toString((Object[])this.y) + "]";
        }
    }
}

