/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.data.Channel;
import gde.data.Record;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTbinReader;
import gde.device.graupner.HoTTbinReaderX;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.FileUtils;
import gde.utils.ObjectKeyCompliance;
import gde.utils.WaitTimer;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.widgets.FileDialog;

public class HoTTAdapterX
extends HoTTAdapter
implements IDevice {
    public HoTTAdapterX(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
    }

    public HoTTAdapterX(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
    }

    @Override
    protected void importDeviceData() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT2400"), (String)"LogData");
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HoTTAdapterX.this.application.setPortConnected(true);
                    boolean isInitialSwitched = false;
                    for (String tmpFileName : fd.getFileNames()) {
                        Object selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        if (!((String)selectedImportFile).toLowerCase().endsWith(".bin")) {
                            if (((String)selectedImportFile).contains(".")) {
                                selectedImportFile = ((String)selectedImportFile).substring(0, ((String)selectedImportFile).indexOf(46));
                            }
                            selectedImportFile = (String)selectedImportFile + ".bin";
                        }
                        HoTTAdapter.log.log(Level.FINE, "selectedImportFile = " + (String)selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        String directoryName = ObjectKeyCompliance.getUpcomingObjectKey((Path)Paths.get((String)selectedImportFile, new String[0]));
                        if (!directoryName.isEmpty()) {
                            ObjectKeyCompliance.createObjectKey((String)directoryName);
                        }
                        try {
                            HoTTbinReaderX.read((String)selectedImportFile, new HoTTAdapter.PickerParameters(HoTTAdapterX.this.pickerParameters));
                            if (!isInitialSwitched) {
                                Channel receiverChannel = (Channel)HoTTAdapterX.this.channels.get((Object)1);
                                HoTTbinReader.channels.switchChannel(receiverChannel.getName());
                                isInitialSwitched = true;
                            }
                            WaitTimer.delay((long)500L);
                        }
                        catch (Exception e) {
                            HoTTAdapter.log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    HoTTAdapterX.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        block0 : switch (this.serialPort.protocolType) {
            case TYPE_19200_V4: {
                switch (dataBuffer[1]) {
                    case -128: {
                        if (dataBuffer.length != 17) break;
                        short tmpPackageLoss = DataParser.parse2Short((byte[])dataBuffer, (int)11);
                        int tmpVoltageRx = dataBuffer[6] & 0xFF;
                        int tmpTemperatureRx = (dataBuffer[7] & 0xFF) - 20;
                        if (this.pickerParameters.isFilterEnabled && (tmpPackageLoss <= -1 || tmpVoltageRx <= -1 || tmpVoltageRx >= 100 || tmpTemperatureRx >= 120)) break;
                        points[0] = 0;
                        points[1] = (dataBuffer[9] & 0xFF) * 1000;
                        points[2] = (dataBuffer[5] & 0xFF) * 1000;
                        points[3] = tmpPackageLoss * 1000;
                        points[4] = (dataBuffer[13] & 0xFF) * 1000;
                        points[5] = (dataBuffer[8] & 0xFF) * 1000;
                        points[6] = tmpVoltageRx * 1000;
                        points[7] = tmpTemperatureRx * 1000;
                        points[8] = (dataBuffer[10] & 0xFF) * 1000;
                        break;
                    }
                    case -116: {
                        if (dataBuffer.length != 57) break;
                        short tmpVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)17);
                        short tmpCurrent = DataParser.parse2Short((byte[])dataBuffer, (int)21);
                        short tmpRevolution = DataParser.parse2Short((byte[])dataBuffer, (int)25);
                        if (this.pickerParameters.isFilterEnabled && (tmpVoltage <= -1 || tmpVoltage >= 1000 || tmpCurrent >= 2550 || tmpRevolution <= -1 || tmpRevolution >= 20000)) break;
                        points[9] = tmpVoltage * 1000;
                        points[10] = DataParser.parse2Short((byte[])dataBuffer, (int)19) * 1000;
                        points[11] = tmpCurrent * 1000;
                        points[12] = DataParser.parse2Short((byte[])dataBuffer, (int)23) * 1000;
                        points[13] = DataParser.parse2Short((byte[])dataBuffer, (int)29) * 1000;
                        points[14] = Double.valueOf((double)points[9] / 1000.0 * (double)points[11]).intValue();
                        points[15] = tmpRevolution * 1000;
                        points[16] = DataParser.parse2Short((byte[])dataBuffer, (int)27) * 1000;
                        points[17] = 0;
                        points[18] = 0;
                        points[19] = DataParser.parse2Short((byte[])dataBuffer, (int)33) * 1000;
                        points[20] = DataParser.parse2Short((byte[])dataBuffer, (int)35) * 1000;
                        points[21] = 0;
                        points[22] = 0;
                    }
                }
                break;
            }
            default: {
                switch (dataBuffer[0]) {
                    case 52: {
                        if (dataBuffer.length < 21) break block0;
                        short tmpPackageLoss = DataParser.parse2Short((byte[])dataBuffer, (int)12);
                        int tmpVoltageRx = dataBuffer[15] & 0xFF;
                        short tmpTemperatureRx = DataParser.parse2Short((byte[])dataBuffer, (int)10);
                        if (this.pickerParameters.isFilterEnabled && (tmpPackageLoss <= -1 || tmpVoltageRx <= -1 || tmpVoltageRx >= 100 || tmpTemperatureRx >= 100)) break block0;
                        this.pickerParameters.reverseChannelPackageLossCounter.add((dataBuffer[5] & 0xFF) == 0 && (dataBuffer[4] & 0xFF) == 0 ? 0 : 1);
                        points[0] = this.pickerParameters.reverseChannelPackageLossCounter.getPercentage() * 1000;
                        points[1] = (dataBuffer[17] & 0xFF) * 1000;
                        points[2] = (dataBuffer[14] & 0xFF) * 1000;
                        points[3] = tmpPackageLoss * 1000;
                        points[4] = (dataBuffer[5] & 0xFF) * 1000;
                        points[5] = (dataBuffer[4] & 0xFF) * 1000;
                        points[6] = tmpVoltageRx * 1000;
                        points[7] = tmpTemperatureRx * 1000;
                        points[8] = (dataBuffer[18] & 0xFF) * 1000;
                        break block0;
                    }
                    case 57: {
                        if (dataBuffer.length < 34) break block0;
                        short tmpVoltage = DataParser.parse2Short((byte[])dataBuffer, (int)10);
                        short tmpCurrent = DataParser.parse2Short((byte[])dataBuffer, (int)14);
                        short tmpRevolution = DataParser.parse2Short((byte[])dataBuffer, (int)18);
                        if (this.pickerParameters.isFilterEnabled && (tmpVoltage <= -1 || tmpVoltage >= 1000 || tmpCurrent >= 2550 || tmpRevolution <= -1 || tmpRevolution >= 20000)) break block0;
                        points[9] = tmpVoltage * 1000;
                        points[10] = DataParser.parse2Short((byte[])dataBuffer, (int)12) * 1000;
                        points[11] = tmpCurrent * 1000;
                        points[12] = DataParser.parse2Short((byte[])dataBuffer, (int)16) * 1000;
                        points[13] = DataParser.parse2Short((byte[])dataBuffer, (int)22) * 1000;
                        points[14] = Double.valueOf((double)points[9] / 1000.0 * (double)points[11]).intValue();
                        points[15] = tmpRevolution * 1000;
                        points[16] = DataParser.parse2Short((byte[])dataBuffer, (int)20) * 1000;
                        points[17] = 0;
                        points[18] = 0;
                        points[19] = DataParser.parse2Short((byte[])dataBuffer, (int)24) * 1000 * 10;
                        points[20] = DataParser.parse2Short((byte[])dataBuffer, (int)26) * 1000 * 10;
                        points[21] = 0;
                        points[22] = 0;
                    }
                }
            }
        }
        return points;
    }

    @Override
    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = 0.0;
        if (record.getAbstractParent().getChannelConfigNumber() == 2 && record.getOrdinal() >= 3 && record.getOrdinal() <= 10) {
            if (this.pickerParameters.isChannelPercentEnabled) {
                if (!record.getUnit().equals("%")) {
                    record.setUnit("%");
                }
                factor = 0.25;
                reduction = 1500.0;
                newValue = (value - reduction) * factor;
            } else {
                if (!record.getUnit().equals("\u00b5sec")) {
                    record.setUnit("\u00b5sec");
                }
                newValue = (value - reduction) * factor + offset;
            }
        } else {
            newValue = (value - reduction) * factor + offset;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }

    @Override
    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = 0.0;
        if (record.getAbstractParent().getChannelConfigNumber() == 2 && record.getOrdinal() >= 3 && record.getOrdinal() <= 10) {
            if (this.pickerParameters.isChannelPercentEnabled) {
                if (!record.getUnit().equals("%")) {
                    record.setUnit("%");
                }
                factor = 0.25;
                reduction = 1500.0;
                newValue = value / factor + reduction;
            } else {
                if (!record.getUnit().equals("\u00b5sec")) {
                    record.setUnit("\u00b5sec");
                }
                newValue = (value - reduction) * factor;
            }
        } else {
            newValue = (value - offset) / factor + reduction;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }
}

