/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.guard;

import gde.config.Settings;
import gde.device.IChannelItem;
import gde.device.ScoreGroupType;
import gde.device.ScoreType;
import gde.device.TrailTypes;
import gde.histo.cache.HistoVault;
import gde.histo.datasources.HistoSet;
import gde.histo.guard.Reminder;
import gde.histo.recordings.TrailSelector;
import gde.histo.utils.ElementaryQuantile;
import gde.log.Level;
import gde.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Guardian {
    private static final String $CLASS_NAME = Guardian.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);

    public static Reminder[] defineMinMaxReminder(HistoVault[] indexedVaults, IChannelItem channelItem, TrailSelector trailSelector, int logLimit, Settings settings) {
        double[][] minMaxQuantiles = Guardian.defineExtremumQuantiles(indexedVaults, channelItem, trailSelector.getExtremumTrailsOrdinals(), settings);
        if (minMaxQuantiles.length == 0) {
            return new Reminder[]{null, null};
        }
        int[] extremumIndices = trailSelector.getExtremumTrailsIndices();
        String[] extremumText = trailSelector.getExtremumTrailsTexts();
        int reminderLevel = settings.getReminderLevel();
        if (reminderLevel == -1) {
            return new Reminder[]{null, null};
        }
        Reminder minReminder = null;
        Reminder maxReminder = null;
        double minWhiskerLimit = minMaxQuantiles[0][ElementaryQuantile.BoxplotItems.QUARTILE1.ordinal()];
        double maxWhiskerLimit = minMaxQuantiles[1][ElementaryQuantile.BoxplotItems.QUARTILE3.ordinal()];
        double closeMinOutlierLimit = minMaxQuantiles[0][ElementaryQuantile.BoxplotItems.LOWER_WHISKER.ordinal()];
        double closeMaxOutlierLimit = minMaxQuantiles[1][ElementaryQuantile.BoxplotItems.UPPER_WHISKER.ordinal()];
        double farMinOutlierLimit = minMaxQuantiles[0][ElementaryQuantile.BoxplotItems.QUARTILE1.ordinal()] - 6.0 * minMaxQuantiles[0][ElementaryQuantile.BoxplotItems.LQT.ordinal()];
        double farMaxOutlierLimit = minMaxQuantiles[1][ElementaryQuantile.BoxplotItems.QUARTILE3.ordinal()] + 6.0 * minMaxQuantiles[1][ElementaryQuantile.BoxplotItems.UQT.ordinal()];
        int actualLimit = logLimit >= 0 && logLimit < indexedVaults.length ? logLimit : indexedVaults.length;
        for (int i = 0; i < actualLimit; ++i) {
            HistoVault vault = indexedVaults[i];
            Integer[] minMaxTrailPoints = Guardian.getExtremumTrailPoints(vault, channelItem, trailSelector);
            if (minMaxTrailPoints[0] == null || minMaxTrailPoints[1] == null) continue;
            double tmpMinValue = HistoSet.decodeVaultValue(channelItem, (double)minMaxTrailPoints[0].intValue() / 1000.0);
            if (HistoSet.fuzzyCompare(tmpMinValue, farMinOutlierLimit) < 0) {
                if (minReminder == null || minReminder.getReminderType() == Reminder.ReminderType.CLOSE || minReminder.getReminderType() == Reminder.ReminderType.WHISKER) {
                    minReminder = new Reminder(Reminder.ReminderType.FAR, farMinOutlierLimit, closeMinOutlierLimit, extremumIndices[0], extremumText[0]);
                }
                minReminder.add(tmpMinValue, i);
            } else if (Reminder.ReminderType.CLOSE.isIncluded(reminderLevel) && HistoSet.fuzzyCompare(tmpMinValue, closeMinOutlierLimit) < 0) {
                if (minReminder == null || minReminder.getReminderType() == Reminder.ReminderType.WHISKER) {
                    minReminder = new Reminder(Reminder.ReminderType.CLOSE, farMinOutlierLimit, closeMinOutlierLimit, extremumIndices[0], extremumText[0]);
                    minReminder.add(tmpMinValue, i);
                } else if (minReminder.getReminderType() == Reminder.ReminderType.CLOSE) {
                    minReminder.add(tmpMinValue, i);
                }
            } else if (Reminder.ReminderType.WHISKER.isIncluded(reminderLevel) && HistoSet.fuzzyCompare(tmpMinValue, minWhiskerLimit) < 0) {
                if (minReminder == null) {
                    minReminder = new Reminder(Reminder.ReminderType.WHISKER, farMinOutlierLimit, closeMinOutlierLimit, extremumIndices[0], extremumText[0]);
                    minReminder.add(tmpMinValue, i);
                } else if (minReminder.getReminderType() == Reminder.ReminderType.WHISKER) {
                    minReminder.add(tmpMinValue, i);
                }
            }
            double tmpMaxValue = HistoSet.decodeVaultValue(channelItem, (double)minMaxTrailPoints[1].intValue() / 1000.0);
            if (HistoSet.fuzzyCompare(tmpMaxValue, farMaxOutlierLimit) > 0) {
                if (maxReminder == null || maxReminder.getReminderType() == Reminder.ReminderType.CLOSE || maxReminder.getReminderType() == Reminder.ReminderType.WHISKER) {
                    maxReminder = new Reminder(Reminder.ReminderType.FAR, farMaxOutlierLimit, closeMaxOutlierLimit, extremumIndices[1], extremumText[1]);
                }
                maxReminder.add(tmpMaxValue, i);
                continue;
            }
            if (Reminder.ReminderType.CLOSE.isIncluded(reminderLevel) && HistoSet.fuzzyCompare(tmpMaxValue, closeMaxOutlierLimit) > 0) {
                if (maxReminder == null || maxReminder.getReminderType() == Reminder.ReminderType.WHISKER) {
                    maxReminder = new Reminder(Reminder.ReminderType.CLOSE, farMaxOutlierLimit, closeMaxOutlierLimit, extremumIndices[1], extremumText[1]);
                    maxReminder.add(tmpMaxValue, i);
                    continue;
                }
                if (maxReminder.getReminderType() != Reminder.ReminderType.CLOSE) continue;
                maxReminder.add(tmpMaxValue, i);
                continue;
            }
            if (!Reminder.ReminderType.WHISKER.isIncluded(reminderLevel) || HistoSet.fuzzyCompare(tmpMaxValue, maxWhiskerLimit) <= 0) continue;
            if (maxReminder == null) {
                maxReminder = new Reminder(Reminder.ReminderType.WHISKER, farMaxOutlierLimit, closeMaxOutlierLimit, extremumIndices[1], extremumText[1]);
                maxReminder.add(tmpMaxValue, i);
                continue;
            }
            if (maxReminder.getReminderType() != Reminder.ReminderType.WHISKER) continue;
            maxReminder.add(tmpMaxValue, i);
        }
        Reminder[] result = new Reminder[]{minReminder, maxReminder};
        return result;
    }

    public static double[][] defineExtremumQuantiles(HistoVault[] vaults, IChannelItem channelItem, int[] extremumOrdinals, Settings settings) {
        ArrayList<Double> decodedMinimums = new ArrayList<Double>();
        ArrayList<Double> decodedMaximums = new ArrayList<Double>();
        for (HistoVault v : vaults) {
            Integer point = channelItem.getVaultPoint(v, extremumOrdinals[0]);
            if (point == null) continue;
            decodedMinimums.add(HistoSet.decodeVaultValue(channelItem, (double)point.intValue() / 1000.0));
            point = channelItem.getVaultPoint(v, extremumOrdinals[1]);
            if (point == null) continue;
            decodedMaximums.add(HistoSet.decodeVaultValue(channelItem, (double)point.intValue() / 1000.0));
        }
        ElementaryQuantile minQuantile = new ElementaryQuantile(decodedMinimums, true, settings);
        ElementaryQuantile maxQuantile = new ElementaryQuantile(decodedMaximums, true, settings);
        Object result = !decodedMinimums.isEmpty() && !decodedMaximums.isEmpty() ? (Object)new double[][]{minQuantile.getTukeyWithQuartileTolerances(), maxQuantile.getTukeyWithQuartileTolerances()} : new double[0][0];
        return result;
    }

    public static double[] defineStandardMinMax(Stream<HistoVault> vaults, IChannelItem channelItem) {
        double[] decodedMinMaxValues = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        vaults.forEach(v -> {
            Integer tmpPoint = channelItem.getVaultPoint((HistoVault)v, TrailTypes.MIN.ordinal());
            if (tmpPoint != null) {
                decodedMinMaxValues[0] = Math.min(decodedMinMaxValues[0], HistoSet.decodeVaultValue(channelItem, (double)tmpPoint.intValue() / 1000.0));
            }
            if ((tmpPoint = channelItem.getVaultPoint((HistoVault)v, TrailTypes.MAX.ordinal())) != null) {
                decodedMinMaxValues[1] = Math.max(decodedMinMaxValues[1], HistoSet.decodeVaultValue(channelItem, (double)tmpPoint.intValue() / 1000.0));
            }
        });
        double[] result = decodedMinMaxValues[0] == Double.MAX_VALUE || decodedMinMaxValues[1] == -1.7976931348623157E308 ? new double[]{0.0, 0.0} : decodedMinMaxValues;
        return result;
    }

    public static double[] defineStandardExtrema(List<HistoVault> vaults, IChannelItem channelItem, Settings settings) {
        double[] result;
        ArrayList<Double> decodedMinValues = new ArrayList<Double>();
        ArrayList<Double> decodedLowValues = new ArrayList<Double>();
        ArrayList<Double> decodedHighValues = new ArrayList<Double>();
        ArrayList<Double> decodedMaxValues = new ArrayList<Double>();
        for (HistoVault v : vaults) {
            Integer tmpPoint = channelItem.getVaultPoint(v, TrailTypes.MIN.ordinal());
            if (tmpPoint != null) {
                decodedMinValues.add(HistoSet.decodeVaultValue(channelItem, (double)tmpPoint.intValue() / 1000.0));
            }
            if ((tmpPoint = channelItem.getVaultPoint(v, TrailTypes.Q0.ordinal())) != null) {
                decodedLowValues.add(HistoSet.decodeVaultValue(channelItem, (double)tmpPoint.intValue() / 1000.0));
            }
            if ((tmpPoint = channelItem.getVaultPoint(v, TrailTypes.Q4.ordinal())) != null) {
                decodedHighValues.add(HistoSet.decodeVaultValue(channelItem, (double)tmpPoint.intValue() / 1000.0));
            }
            if ((tmpPoint = channelItem.getVaultPoint(v, TrailTypes.MAX.ordinal())) == null) continue;
            decodedMaxValues.add(HistoSet.decodeVaultValue(channelItem, (double)tmpPoint.intValue() / 1000.0));
        }
        if (decodedLowValues.isEmpty() || decodedHighValues.isEmpty()) {
            result = new double[]{0.0, 0.0};
        } else {
            double upperWhisker;
            result = Guardian.getExtrema(channelItem.getName(), decodedLowValues, decodedHighValues, settings);
            double lowerWhisker = new ElementaryQuantile(decodedMinValues, true, settings).getQuantileLowerWhisker();
            if (lowerWhisker < result[0]) {
                result[0] = Math.min(lowerWhisker, result[0]);
                log.log(Level.FINER, "lower corrected to ", lowerWhisker);
            }
            if ((upperWhisker = new ElementaryQuantile(decodedMaxValues, true, settings).getQuantileUpperWhisker()) > result[1]) {
                result[1] = Math.max(upperWhisker, result[1]);
                log.log(Level.FINER, "upper corrected to ", upperWhisker);
            }
        }
        return result;
    }

    public static double[] defineAlienMinMax(Stream<HistoVault> vaults, IChannelItem channelItem, int trailOrdinal) {
        Stream<Integer> alienPoints = vaults.map(v -> channelItem.getVaultPoint((HistoVault)v, trailOrdinal));
        DoubleSummaryStatistics decodedAliens = alienPoints.filter(Objects::nonNull).map(i -> HistoSet.decodeVaultValue(channelItem, (double)i.intValue() / 1000.0)).collect(Collectors.summarizingDouble(Double::doubleValue));
        double[] result = decodedAliens.getCount() == 0L ? new double[]{0.0, 0.0} : new double[]{decodedAliens.getMin(), decodedAliens.getMax()};
        return result;
    }

    public static double[] defineAlienExtrema(List<HistoVault> vaults, IChannelItem channelItem, int trailOrdinal, Settings settings) {
        Stream<Integer> alienPoints = vaults.stream().map(v -> channelItem.getVaultPoint((HistoVault)v, trailOrdinal));
        List<Double> decodedAliens = alienPoints.filter(Objects::nonNull).map(i -> HistoSet.decodeVaultValue(channelItem, (double)i.intValue() / 1000.0)).collect(Collectors.toList());
        double[] result = decodedAliens.isEmpty() ? new double[]{0.0, 0.0} : Guardian.getExtrema(channelItem.getName(), decodedAliens, decodedAliens, settings);
        return result;
    }

    public static double[] defineScoreMinMax(Stream<HistoVault> vaults, ScoreGroupType scoregroup) {
        double[] decodedMinMaxValues = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        List scoreOrdinals = scoregroup.getScore().stream().map(ScoreType::getTrailOrdinal).collect(Collectors.toList());
        vaults.forEach(v -> {
            Stream<Integer> scoregroupPoints = scoreOrdinals.stream().map(t -> scoregroup.getVaultPoint((HistoVault)v, (int)t));
            DoubleSummaryStatistics stats = scoregroupPoints.map(i -> HistoSet.decodeVaultValue(scoregroup, (double)i.intValue() / 1000.0)).collect(Collectors.summarizingDouble(Double::doubleValue));
            decodedMinMaxValues[0] = Math.min(decodedMinMaxValues[0], stats.getMin());
            decodedMinMaxValues[1] = Math.max(decodedMinMaxValues[1], stats.getMax());
        });
        double[] result = decodedMinMaxValues[0] == Double.MAX_VALUE || decodedMinMaxValues[1] == -1.7976931348623157E308 ? new double[]{0.0, 0.0} : decodedMinMaxValues;
        return result;
    }

    public static double[] defineScoreExtrema(List<HistoVault> vaults, ScoreGroupType scoregroup, Settings settings) {
        ArrayList<Double> decodedLowValues = new ArrayList<Double>();
        ArrayList<Double> decodedHighValues = new ArrayList<Double>();
        List scoreOrdinals = scoregroup.getScore().stream().map(ScoreType::getTrailOrdinal).collect(Collectors.toList());
        for (HistoVault v : vaults) {
            Stream<Integer> scoregroupPoints = scoreOrdinals.stream().map(t -> scoregroup.getVaultPoint(v, (int)t));
            DoubleSummaryStatistics stats = scoregroupPoints.map(i -> HistoSet.decodeVaultValue(scoregroup, (double)i.intValue() / 1000.0)).collect(Collectors.summarizingDouble(Double::doubleValue));
            decodedLowValues.add(stats.getMin());
            decodedHighValues.add(stats.getMax());
        }
        log.finer(() -> scoregroup.getName() + "  decodedMinimums=" + Arrays.toString(decodedLowValues.toArray()) + "  decodedMaximums=" + Arrays.toString(decodedHighValues.toArray()));
        double[] extrema = Guardian.getExtrema(scoregroup.getName(), decodedLowValues, decodedHighValues, settings);
        return extrema;
    }

    private static Integer[] getExtremumTrailPoints(HistoVault vault, IChannelItem channelItem, TrailSelector trailSelector) {
        int[] extremumOrdinals = trailSelector.getExtremumTrailsOrdinals();
        return new Integer[]{channelItem.getVaultPoint(vault, extremumOrdinals[0]), channelItem.getVaultPoint(vault, extremumOrdinals[1])};
    }

    private static double[] getExtrema(String recordName, List<Double> decodedLowValues, List<Double> decodedHighValues, Settings settings) {
        ElementaryQuantile<Double> minQuantile = new ElementaryQuantile<Double>(decodedLowValues, true, settings);
        ElementaryQuantile<Double> maxQuantile = new ElementaryQuantile<Double>(decodedHighValues, true, settings);
        int scaleSpread = settings.getSummaryScaleSpread();
        double scaleMin = minQuantile.getExtremumFromRange(0.674489694, -scaleSpread);
        double scaleMax = maxQuantile.getExtremumFromRange(0.674489694, scaleSpread);
        double[] result = new double[]{Math.min(minQuantile.getQuantileLowerWhisker(), scaleMin), Math.max(maxQuantile.getQuantileUpperWhisker(), scaleMax)};
        log.finer(() -> recordName + " Quantile.Size=" + decodedLowValues.size() + "/" + decodedHighValues.size() + Arrays.toString(result));
        return result;
    }
}

