/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader;

import com.monstarmike.tlmreader.Flight;
import com.monstarmike.tlmreader.TlmParser;
import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.datablock.HeaderDataBlock;
import com.monstarmike.tlmreader.datablock.HeaderNameBlock;
import com.monstarmike.tlmreader.datablock.HeaderRpmBlock;
import com.monstarmike.tlmreader.datablock.HeaderRxBlock;
import com.monstarmike.tlmreader.datablock.HeaderVoltBlock;
import java.io.BufferedInputStream;
import java.io.IOException;

final class TlmFlightParser
extends TlmParser {
    private int index;
    private Flight flight;

    TlmFlightParser() {
    }

    @Override
    protected void handleHeaderBlock(byte[] headerBytes, int flightNumber) {
        if (flightNumber != this.index) {
            return;
        }
        if (HeaderNameBlock.isHeaderName(headerBytes)) {
            this.flight = new Flight();
            this.getCurrentFlight().addHeaderNameBlock(new HeaderNameBlock(headerBytes));
        } else if (HeaderRpmBlock.isRpmHeader(headerBytes)) {
            this.getCurrentFlight().addRpmHeaderBlock(new HeaderRpmBlock(headerBytes));
        } else if (HeaderVoltBlock.isVoltHeader(headerBytes)) {
            this.getCurrentFlight().addHeaderBlock(new HeaderVoltBlock(headerBytes));
        } else if (HeaderRxBlock.isRxHeader(headerBytes)) {
            this.getCurrentFlight().addHeaderBlock(new HeaderRxBlock(headerBytes));
        } else {
            this.getCurrentFlight().addHeaderBlock(new HeaderDataBlock(headerBytes));
        }
    }

    @Override
    protected void handleDataBlock(byte[] dataBytes, int flightNumber) {
        if (flightNumber != this.index) {
            return;
        }
        DataBlock createdDataBlock = DataBlock.createDataBlock(dataBytes, this.getCurrentFlight().getRpmHeader());
        if (createdDataBlock != null) {
            this.getCurrentFlight().addDataBlock(createdDataBlock);
        }
    }

    private Flight getCurrentFlight() {
        if (this.flight == null) {
            throw new RuntimeException("No current Flight available");
        }
        return this.flight;
    }

    public Flight parseFlight(BufferedInputStream bufferedStream, int index) throws IOException {
        this.index = index;
        this.parseStream(bufferedStream);
        return this.flight;
    }
}

