/*
 *  Copyright © 2017-2025 Wellington Wallace
 *
 *  This file is part of Easy Effects.
 *
 *  Easy Effects is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Easy Effects is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Easy Effects. If not, see <https://www.gnu.org/licenses/>.
 */

#pragma once

namespace tags::resources {

// Custom icon path

inline constexpr auto icons = "/com/github/wwmm/easyeffects/icons";

// Custom css file path

inline constexpr auto css = "/com/github/wwmm/easyeffects/ui/custom.css";

// Flatpak info file

inline constexpr auto flatpak_info_file = "/.flatpak-info";

// Path to the widgets xml files

inline constexpr auto app_info_ui = "/com/github/wwmm/easyeffects/ui/app_info.ui";

inline constexpr auto application_window_ui = "/com/github/wwmm/easyeffects/ui/application_window.ui";

inline constexpr auto apps_box_ui = "/com/github/wwmm/easyeffects/ui/apps_box.ui";

inline constexpr auto autogain_ui = "/com/github/wwmm/easyeffects/ui/autogain.ui";

inline constexpr auto autoload_row_ui = "/com/github/wwmm/easyeffects/ui/autoload_row.ui";

inline constexpr auto bass_enhancer_ui = "/com/github/wwmm/easyeffects/ui/bass_enhancer.ui";

inline constexpr auto bass_loudness_ui = "/com/github/wwmm/easyeffects/ui/bass_loudness.ui";

inline constexpr auto blocklist_menu_ui = "/com/github/wwmm/easyeffects/ui/blocklist_menu.ui";

inline constexpr auto chart_ui = "/com/github/wwmm/easyeffects/ui/chart.ui";

inline constexpr auto compressor_ui = "/com/github/wwmm/easyeffects/ui/compressor.ui";

inline constexpr auto convolver_ui = "/com/github/wwmm/easyeffects/ui/convolver.ui";

inline constexpr auto convolver_menu_impulses_ui = "/com/github/wwmm/easyeffects/ui/convolver_menu_impulses.ui";

inline constexpr auto convolver_menu_combine_ui = "/com/github/wwmm/easyeffects/ui/convolver_menu_combine.ui";

inline constexpr auto crossfeed_ui = "/com/github/wwmm/easyeffects/ui/crossfeed.ui";

inline constexpr auto crystalizer_ui = "/com/github/wwmm/easyeffects/ui/crystalizer.ui";

inline constexpr auto crystalizer_band_ui = "/com/github/wwmm/easyeffects/ui/crystalizer_band.ui";

inline constexpr auto deepfilternet_ui = "/com/github/wwmm/easyeffects/ui/deepfilternet.ui";

inline constexpr auto deesser_ui = "/com/github/wwmm/easyeffects/ui/deesser.ui";

inline constexpr auto delay_ui = "/com/github/wwmm/easyeffects/ui/delay.ui";

inline constexpr auto echo_canceller_ui = "/com/github/wwmm/easyeffects/ui/echo_canceller.ui";

inline constexpr auto effects_box_ui = "/com/github/wwmm/easyeffects/ui/effects_box.ui";

inline constexpr auto equalizer_band_ui = "/com/github/wwmm/easyeffects/ui/equalizer_band.ui";

inline constexpr auto equalizer_ui = "/com/github/wwmm/easyeffects/ui/equalizer.ui";

inline constexpr auto exciter_ui = "/com/github/wwmm/easyeffects/ui/exciter.ui";

inline constexpr auto expander_ui = "/com/github/wwmm/easyeffects/ui/expander.ui";

inline constexpr auto filter_ui = "/com/github/wwmm/easyeffects/ui/filter.ui";

inline constexpr auto gate_ui = "/com/github/wwmm/easyeffects/ui/gate.ui";

inline constexpr auto level_meter_ui = "/com/github/wwmm/easyeffects/ui/level_meter.ui";

inline constexpr auto limiter_ui = "/com/github/wwmm/easyeffects/ui/limiter.ui";

inline constexpr auto loudness_ui = "/com/github/wwmm/easyeffects/ui/loudness.ui";

inline constexpr auto maximizer_ui = "/com/github/wwmm/easyeffects/ui/maximizer.ui";

inline constexpr auto multiband_compressor_ui = "/com/github/wwmm/easyeffects/ui/multiband_compressor.ui";

inline constexpr auto multiband_compressor_band_ui = "/com/github/wwmm/easyeffects/ui/multiband_compressor_band.ui";

inline constexpr auto multiband_gate_ui = "/com/github/wwmm/easyeffects/ui/multiband_gate.ui";

inline constexpr auto multiband_gate_band_ui = "/com/github/wwmm/easyeffects/ui/multiband_gate_band.ui";

inline constexpr auto pipe_manager_box_ui = "/com/github/wwmm/easyeffects/ui/pipe_manager_box.ui";

inline constexpr auto pitch_ui = "/com/github/wwmm/easyeffects/ui/pitch.ui";

inline constexpr auto plugin_row_ui = "/com/github/wwmm/easyeffects/ui/plugin_row.ui";

inline constexpr auto plugins_box_ui = "/com/github/wwmm/easyeffects/ui/plugins_box.ui";

inline constexpr auto plugins_menu_ui = "/com/github/wwmm/easyeffects/ui/plugins_menu.ui";

inline constexpr auto preferences_general_ui = "/com/github/wwmm/easyeffects/ui/preferences_general.ui";

inline constexpr auto preferences_spectrum_ui = "/com/github/wwmm/easyeffects/ui/preferences_spectrum.ui";

inline constexpr auto preferences_window_ui = "/com/github/wwmm/easyeffects/ui/preferences_window.ui";

inline constexpr auto preset_row_ui = "/com/github/wwmm/easyeffects/ui/preset_row.ui";

inline constexpr auto preset_row_community_ui = "/com/github/wwmm/easyeffects/ui/preset_community_row.ui";

inline constexpr auto presets_menu_ui = "/com/github/wwmm/easyeffects/ui/presets_menu.ui";

inline constexpr auto reverb_ui = "/com/github/wwmm/easyeffects/ui/reverb.ui";

inline constexpr auto rnnoise_ui = "/com/github/wwmm/easyeffects/ui/rnnoise.ui";

inline constexpr auto speex_ui = "/com/github/wwmm/easyeffects/ui/speex.ui";

inline constexpr auto shortcuts_ui = "/com/github/wwmm/easyeffects/ui/shortcuts.ui";

inline constexpr auto stereo_tools_ui = "/com/github/wwmm/easyeffects/ui/stereo_tools.ui";

}  // namespace tags::resources
