# Copyright 2010 Paul Hummer <paul@eventuallyanyway.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

from distutils.core import setup
from distutils.command.build_py import build_py as _build_py
from subprocess import call
from textwrap import dedent
import os


class build_py(_build_py):
    '''Custom install command.'''

    def run(self):
        call(['pykdeuic4', '-o', 'gally/twoPanes.py', 'twoPanes.ui'])
        call(['pandoc', '-s', '-w', 'man', 'gally.1.md', '-o', 'gally.1'])
        call(['gzip','gally.1'])
        _build_py.run(self)


setup(
    cmdclass={'build_py': build_py},
    name=u'Gally',
    version=u'0.5b',
    description=u'Sign language tutor',
    url=u'http://launchpad.net/gally',
    license='GPLv3',
    packages=['gally',],
    package_data={'gally': ['twoPanes.ui',]},
    scripts=['scripts/gally',],
    data_files=[(os.path.join('share','kde4','apps','gally'), ['gallyui.rc']), 
        (os.path.join('share','applications','kde4'), ['gally.desktop']), 
        (os.path.join('share','icons','hicolor','16x16','apps'), ['icons/16x16/gally.png']), 
        (os.path.join('share','icons','hicolor','32x32','apps'), ['icons/32x32/gally.png']), 
        (os.path.join('share','icons','hicolor','48x48','apps'), ['icons/48x48/gally.png']), 
        (os.path.join('share','icons','hicolor','64x64','apps'), ['icons/64x64/gally.png']), 
        (os.path.join('share','icons','hicolor','scalable','apps'), ['icons/scalable/gally.svg']),
        (os.path.join('share','man','man1'),['gally.1.gz'])],
    long_description=dedent('''
        Gally is a vocabulary and grammar teacher for sign language.'''))
