-- ------------------------------------------------------------------------- --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/objects/apps/person_browser.adb,v $
--  Description     : Display the information of all persons                 --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 30-Dec-2006                                            --
--  Last Modified By: $Author: merdmann $                                    --
--  Last Modified On: $Date: 2007/02/03 14:59:52 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2006-2007 Michael Erdmann                                  --
--                                                                           --
--  GNADE is copyrighted by the persons and institutions enumerated in the   --
--  AUTHORS file. This file is located in the root directory of the          --
--  GNADE distribution.                                                      --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNADE; see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from      --
--  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
--  files  to produce an executable, these  units or libraries do not by     --
--  itself cause the resulting  executable  to  be covered  by the  GNU      --
--  General  Public  License.  This exception does not however invalidate    --
--  any other reasons why  the executable file  might be covered by the      --
--  GNU Public License.                                                      --
--                                                                           --
-- ------------------------------------------------------------------------- --
with Ada.Text_IO;				use Ada.Text_IO;
with Ada.Strings.Unbounded;			use Ada.Strings.Unbounded;
with Person;					use Person;

with Ada.Text_IO.Editing;                       use Ada.Text_IO.Editing;
with TAM.Persistent;				use TAM.Persistent;
with Objects;					use Objects;
with Person;					use Person;
with Account;					use Account;

package body Person_Browser is

   Version : constant String :=
      "$Id: person_browser.adb,v 1.3 2007/02/03 14:59:52 merdmann Exp $";

   -------------
   -- Execute --
   -------------
   procedure Execute(
      This     : in out Object;
      Instance : in Persistent.Object'Class ) is
      -- this procedure is called for each person in the data base

      -----------
      -- Field --
      -----------
      function Field(
         S      : in String;
         Length : in Positive ) return String is

         Result : String( 1..Length ) := (others => ' ');
         J      : Positive := Result'First;
      begin
         for i in S'Range loop
            Result(J) := S(i);
            J := J + 1;
            exit when not (J in Result'Range);
         end loop;

         return Result;
      end Field;

      function Field(
         S      : in Unbounded_String;
         Length : in Positive ) return String is
      begin
         return Field( To_String(S), Length );
      end Field;

      ----------------------
      -- Display_Accounts --
      ----------------------
      procedure Display_Accounts is
         Account_ID : OID_Array_Type( 1..100 ) := (others=>0);
         Length     : Integer := 0;
      begin
         Get_Related( OID( Instance ), "Has_Account" , Account_ID, Length );
         for i in 1..Length loop
            declare
               A : Account.Object;
            begin
               Get_Object(A, ID => Account_ID(i));
               Put( Field( A.Title,15 ) &":");
               Put( Field( Integer'Image(A.Ballance),8 ) );
            end ;
         end loop;
      end Display_Accounts;

      P : Person.Object := Person.Object(Instance);

   begin
      Put( Field(P.Firstname, 15) & " " & Field(P.Lastname,15) );
      Display_Accounts;

      Put_Line("");

   end Execute;

   -------------
   -- Persons --
   -------------
   procedure Persons is
      This     : Object;
      Instance : Person.Object;
      Done     : Boolean := False;
   begin
      Run( This, Instance, Done );

      if not Done then
         Put_line("Some Lines may missing due to an internal abort");
      end if;
   end Persons;

end Person_Browser;
