---
myst:
  html_meta:
    keywords: LaTeX, composition, tableaux
---

# Tableaux

Ce thème regroupe les questions portant sur les
[tableaux](https://fr.wikipedia.org/wiki/Tableau_synoptique), leur
construction et leur mise en forme. Si certaines questions évoquent le
positionnement des tableaux, il est intéressant ici de parcourir les
questions portant sur les [flottants](/3_composition/flottants/start)
(ces derniers permettant, entre autres, de donner une
[légende](/3_composition/flottants/legendes/start) et une numération aux
tableaux).

Quelques questions portant sur des sous-parties des tableaux ont été
regroupées :

-   les [colonnes](/3_composition/tableaux/colonnes/start) ;
-   les [lignes](/3_composition/tableaux/lignes/start) ;
-   les [cellules](/3_composition/tableaux/cellules/start) ;
-   les [filets](/3_composition/tableaux/filets/start), traits séparant
    les éléments d'un tableau ;
-   les [tabulations](/3_composition/tableaux/tabulations/start) qui
    permettent d'élaborer un tableau simplifié.

Quelques questions portent sur **la création et la gestion des tableaux** :

-   [](/3_composition/tableaux/construire_un_tableau)
-   [](/3_composition/tableaux/deux_tableaux_cote_a_cote)
-   [](/3_composition/tableaux/changer_l_orientation_d_un_tableau)
-   [](/3_composition/tableaux/tableau_sur_plusieurs_pages)
-   [](/3_composition/tableaux/tableau_tabularray)


D'autres traitent le sujet du **style des tableaux** :

-   [](/3_composition/tableaux/mes_tableaux_sont_moches)
-   [](/3_composition/tableaux/presentation_professionnelle_d_un_tableau)
-   [](/3_composition/tableaux/fixer_la_largeur_d_un_tableau)


Enfin une question évoque **les tableaux et notes de bas de page** :

-   [](/3_composition/tableaux/notes_de_bas_de_tableau)


```{toctree}
:glob: true
:maxdepth: 1
:hidden:

*/start
*
```