IF(ROCSOLVER_LIBRARIES AND ROCSOLVER_LIBRARY_DIRS AND ROCSOLVER_INCLUDE_DIRS)
  kokkoskernels_find_imported(ROCSOLVER INTERFACE
    LIBRARIES ${ROCSOLVER_LIBRARIES}
    LIBRARY_PATHS ${ROCSOLVER_LIBRARY_DIRS}
    HEADER_PATHS ${ROCSOLVER_INCLUDE_DIRS}
  )
ELSEIF(ROCSOLVER_LIBRARIES AND ROCSOLVER_LIBRARY_DIRS)
  kokkoskernels_find_imported(ROCSOLVER INTERFACE
    LIBRARIES ${ROCSOLVER_LIBRARIES}
    LIBRARY_PATHS ${ROCSOLVER_LIBRARY_DIRS}
    HEADER rocsolver.h
  )
ELSEIF(ROCSOLVER_LIBRARIES)
  kokkoskernels_find_imported(ROCSOLVER INTERFACE
    LIBRARIES ${ROCSOLVER_LIBRARIES}
    HEADER rocsolver.h
  )
ELSEIF(ROCSOLVER_LIBRARY_DIRS)
  kokkoskernels_find_imported(ROCSOLVER INTERFACE
    LIBRARIES rocsolver
    LIBRARY_PATHS ${ROCSOLVER_LIBRARY_DIRS}
    HEADER rocsolver.h
  )
ELSEIF(ROCSOLVER_ROOT OR KokkosKernels_ROCSOLVER_ROOT) # nothing specific provided, just ROOT
  kokkoskernels_find_imported(ROCSOLVER INTERFACE
    LIBRARIES rocsolver
    HEADER rocsolver.h
  )
ELSE() # backwards-compatible way
  FIND_PACKAGE(ROCSOLVER)
  INCLUDE(FindPackageHandleStandardArgs)
  IF (NOT ROCSOLVER_FOUND)
    #Important note here: this find Module is named TPLROCSOLVER
    #The eventual target is named ROCSOLVER. To avoid naming conflicts
    #the find module is called TPLROCSOLVER. This call will cause
    #the find_package call to fail in a "standard" CMake way
    FIND_PACKAGE_HANDLE_STANDARD_ARGS(TPLROCSOLVER REQUIRED_VARS ROCSOLVER_FOUND)
  ELSE()
    #The libraries might be empty - OR they might explicitly be not found
    IF("${ROCSOLVER_LIBRARIES}" MATCHES "NOTFOUND")
      FIND_PACKAGE_HANDLE_STANDARD_ARGS(TPLROCSOLVER REQUIRED_VARS ROCSOLVER_LIBRARIES)
    ELSE()
      KOKKOSKERNELS_CREATE_IMPORTED_TPL(ROCSOLVER INTERFACE
        LINK_LIBRARIES "${ROCSOLVER_LIBRARIES}")
    ENDIF()
  ENDIF()
ENDIF()

