/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.context.api.ContextMap;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.AbstractHttpMetaData;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import java.util.Objects;
import javax.annotation.Nullable;

class DefaultHttpResponseMetaData
extends AbstractHttpMetaData
implements HttpResponseMetaData {
    private HttpResponseStatus status;

    DefaultHttpResponseMetaData(HttpResponseStatus status, HttpProtocolVersion version, HttpHeaders headers, @Nullable ContextMap context) {
        super(version, headers, context);
        this.status = Objects.requireNonNull(status);
    }

    @Override
    public HttpResponseMetaData version(HttpProtocolVersion version) {
        super.version(version);
        return this;
    }

    @Override
    public final HttpResponseStatus status() {
        return this.status;
    }

    @Override
    public HttpResponseMetaData status(HttpResponseStatus status) {
        this.status = Objects.requireNonNull(status);
        return this;
    }

    @Override
    @Deprecated
    public HttpResponseMetaData encoding(ContentCodec encoding) {
        super.encoding(encoding);
        return this;
    }

    @Override
    public HttpResponseMetaData context(ContextMap context) {
        super.context(context);
        return this;
    }

    @Override
    public final String toString() {
        return this.version() + " " + this.status();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultHttpResponseMetaData that = (DefaultHttpResponseMetaData)o;
        return this.status.equals(that.status);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.status.hashCode();
    }
}

