/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.geocoder;

import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.apache.baremaps.geocoder.GeonamesQueryBuilder;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="search", description={"Search geonames index."})
public class Search
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(Search.class);
    @CommandLine.Option(names={"--index"}, paramLabel="INDEX", description={"The path to the lucene index."}, required=true)
    private Path indexDirectory;
    @CommandLine.Option(names={"--terms"}, paramLabel="terms", description={"The terms to search in the index."}, required=true)
    private String terms;
    @CommandLine.Option(names={"--country"}, paramLabel="COUNTRY", description={"The country code filter."}, required=false)
    private String countryCode = "";
    @CommandLine.Option(names={"--limit"}, paramLabel="LIMIT", description={"The number of result to return."}, required=false)
    private Integer limit = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        try (FSDirectory directory = MMapDirectory.open((Path)this.indexDirectory);
             SearcherManager searcherManager = new SearcherManager((Directory)directory, new SearcherFactory());){
            Query query = new GeonamesQueryBuilder().queryText(this.terms).countryCode(this.countryCode).build();
            IndexSearcher searcher = (IndexSearcher)searcherManager.acquire();
            try {
                TopDocs result = searcher.search(query, this.limit.intValue());
                for (ScoreDoc hit : result.scoreDocs) {
                    Document document = searcher.doc(hit.doc);
                    logger.info("{}", (Object)document);
                }
            }
            finally {
                searcherManager.release((Object)searcher);
            }
        }
        return 0;
    }
}

