/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.baremaps.collection.DataCollection;
import org.apache.baremaps.collection.DataCollectionException;
import org.apache.baremaps.collection.memory.Memory;
import org.apache.baremaps.collection.memory.OffHeapMemory;
import org.apache.baremaps.collection.type.DataType;

public class AppendOnlyBuffer<E>
extends DataCollection<E> {
    private final DataType<E> dataType;
    private final Memory memory;
    private final long segmentSize;
    private long offset;
    private long size;
    private Lock lock = new ReentrantLock();

    public AppendOnlyBuffer(DataType<E> dataType) {
        this(dataType, new OffHeapMemory());
    }

    public AppendOnlyBuffer(DataType<E> dataType, Memory memory) {
        this.dataType = dataType;
        this.memory = memory;
        this.segmentSize = memory.segmentSize();
        this.offset = 8L;
        this.size = memory.segment(0).getLong(0);
    }

    public long addPositioned(E value) {
        int valueSize = this.dataType.size(value);
        if ((long)valueSize > this.segmentSize) {
            throw new DataCollectionException("The value is too big to fit in a segment");
        }
        this.lock.lock();
        long position = this.offset;
        long segmentIndex = position / this.segmentSize;
        long segmentOffset = position % this.segmentSize;
        if (segmentOffset + (long)valueSize > this.segmentSize) {
            segmentOffset = 0L;
            position = ++segmentIndex * this.segmentSize;
        }
        this.offset = position + (long)valueSize;
        ++this.size;
        this.lock.unlock();
        ByteBuffer segment = this.memory.segment((int)segmentIndex);
        this.dataType.write(segment, (int)segmentOffset, value);
        return position;
    }

    @Override
    public boolean add(E value) {
        this.addPositioned(value);
        return true;
    }

    public E read(long position) {
        long segmentIndex = position / this.segmentSize;
        long segmentOffset = position % this.segmentSize;
        ByteBuffer buffer = this.memory.segment((int)segmentIndex);
        return this.dataType.read(buffer, (int)segmentOffset);
    }

    @Override
    public long sizeAsLong() {
        return this.size;
    }

    public void close() {
        this.memory.segment(0).putLong(0, this.size);
    }

    @Override
    public void clear() {
        try {
            this.memory.clear();
        }
        catch (IOException e) {
            throw new DataCollectionException(e);
        }
    }

    public BufferIterator iterator() {
        long size = this.sizeAsLong();
        return new BufferIterator(size);
    }

    public class BufferIterator
    implements Iterator<E> {
        private final long size;
        private long index;
        private long position;

        public BufferIterator(long size) {
            this.size = size;
            this.index = 0L;
            this.position = 8L;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public E next() {
            int size;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long segmentIndex = this.position / AppendOnlyBuffer.this.segmentSize;
            long segmentOffset = this.position % AppendOnlyBuffer.this.segmentSize;
            ByteBuffer segment = AppendOnlyBuffer.this.memory.segment((int)segmentIndex);
            try {
                size = AppendOnlyBuffer.this.dataType.size(segment, (int)segmentOffset);
            }
            catch (IndexOutOfBoundsException e) {
                size = 0;
            }
            if (segmentOffset + (long)size > AppendOnlyBuffer.this.segmentSize || size == 0) {
                segmentOffset = 0L;
                this.position = ++segmentIndex * AppendOnlyBuffer.this.segmentSize;
                segment = AppendOnlyBuffer.this.memory.segment((int)segmentIndex);
                size = AppendOnlyBuffer.this.dataType.size(segment, (int)segmentOffset);
            }
            this.position += (long)size;
            ++this.index;
            return AppendOnlyBuffer.this.dataType.read(segment, (int)segmentOffset);
        }

        public long getPosition() {
            return this.position;
        }
    }
}

