/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection;

import com.google.common.collect.Streams;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DataMap<E>
implements Map<Long, E> {
    @Override
    public void putAll(Map<? extends Long, ? extends E> m) {
        m.forEach(this::put);
    }

    public List<E> getAll(List<Long> keys) {
        return Streams.stream(keys).map(this::get).toList();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract long sizeAsLong();

    @Override
    public int size() {
        return (int)Math.min(this.sizeAsLong(), Integer.MAX_VALUE);
    }

    protected abstract Iterator<Long> keyIterator();

    @Override
    public Set<Long> keySet() {
        return new KeySet();
    }

    protected abstract Iterator<E> valueIterator();

    @Override
    public Collection<E> values() {
        return new ValueCollection();
    }

    protected abstract Iterator<Map.Entry<Long, E>> entryIterator();

    @Override
    public Set<Map.Entry<Long, E>> entrySet() {
        return new EntrySet();
    }

    private class KeySet
    extends AbstractSet<Long> {
        private KeySet() {
        }

        @Override
        public Iterator<Long> iterator() {
            return DataMap.this.keyIterator();
        }

        @Override
        public int size() {
            return DataMap.this.size();
        }
    }

    private class ValueCollection
    extends AbstractCollection<E> {
        private ValueCollection() {
        }

        @Override
        public Iterator<E> iterator() {
            return DataMap.this.valueIterator();
        }

        @Override
        public int size() {
            return DataMap.this.size();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<Long, E>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Long, E>> iterator() {
            return DataMap.this.entryIterator();
        }

        @Override
        public int size() {
            return DataMap.this.size();
        }
    }
}

