/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.iploc;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.baremaps.geocoder.GeonamesQueryBuilder;
import org.apache.baremaps.geocoder.IsoCountriesUtils;
import org.apache.baremaps.iploc.data.InetnumLocation;
import org.apache.baremaps.iploc.data.IpLocStats;
import org.apache.baremaps.iploc.data.Ipv4Range;
import org.apache.baremaps.iploc.data.Location;
import org.apache.baremaps.iploc.database.InetnumLocationDao;
import org.apache.baremaps.iploc.database.InetnumLocationDaoSqliteImpl;
import org.apache.baremaps.iploc.nic.NicAttribute;
import org.apache.baremaps.iploc.nic.NicObject;
import org.apache.baremaps.stream.StreamUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;

public class IpLoc {
    private final float SCORE_THRESHOLD = 0.1f;
    private final InetnumLocationDao inetnumLocationDao;
    private final SearcherManager searcherManager;
    private IpLocStats iplocStats;

    public IpLoc(String databaseUrl, SearcherManager searcherManager) {
        this.inetnumLocationDao = new InetnumLocationDaoSqliteImpl(databaseUrl);
        this.iplocStats = new IpLocStats();
        this.searcherManager = searcherManager;
    }

    public void insertNicObjects(Stream<NicObject> nicObjects) {
        StreamUtils.partition(nicObjects.filter(this::isInetnum).map(this::nicObjectToInetnumLocation).filter(Optional::isPresent).map(Optional::get), 100).map(partition -> partition.collect(Collectors.toList())).forEach(this.inetnumLocationDao::save);
    }

    private boolean isInetnum(NicObject nicObject) {
        return "inetnum".equals(nicObject.type());
    }

    private Optional<InetnumLocation> nicObjectToInetnumLocation(NicObject nicObject) {
        try {
            String countryUppercase;
            Optional<Location> location;
            Optional<Location> location2;
            if (nicObject.attributes().isEmpty()) {
                return Optional.empty();
            }
            NicAttribute firstAttribute = nicObject.attributes().get(0);
            if (!Objects.equals(firstAttribute.name(), "inetnum")) {
                return Optional.empty();
            }
            Ipv4Range ipRange = new Ipv4Range(firstAttribute.value());
            Map<String, String> attributes = nicObject.toMap();
            String network = attributes.getOrDefault("netname", "unknown");
            if (attributes.containsKey("geoloc") && (location2 = this.stringToLocation(attributes.get("geoloc"))).isPresent()) {
                this.iplocStats.incrementInsertedByGeolocCount();
                return Optional.of(new InetnumLocation(attributes.get("geoloc"), ipRange, location2.get(), network, attributes.get("country")));
            }
            if (attributes.containsKey("address") && (location2 = this.findLocation(attributes.get("address"), attributes.get("country"))).isPresent()) {
                this.iplocStats.incrementInsertedByAddressCount();
                return Optional.of(new InetnumLocation(attributes.get("address"), ipRange, location2.get(), network, attributes.get("country")));
            }
            if (attributes.containsKey("descr") && (location2 = this.findLocation(attributes.get("descr"), attributes.get("country"))).isPresent()) {
                this.iplocStats.incrementInsertedByDescrCount();
                return Optional.of(new InetnumLocation(attributes.get("descr"), ipRange, location2.get(), network, attributes.get("country")));
            }
            if (attributes.containsKey("name") && (location2 = this.findLocation(attributes.get("name"), attributes.get("country"))).isPresent()) {
                this.iplocStats.incrementInsertedByDescrCount();
                return Optional.of(new InetnumLocation(attributes.get("name"), ipRange, location2.get(), network, attributes.get("country")));
            }
            if (attributes.containsKey("country") && IsoCountriesUtils.containsCountry(attributes.get("country").toUpperCase()) && (location = this.findLocation(IsoCountriesUtils.getCountry(countryUppercase = attributes.get("country").toUpperCase()), countryUppercase)).isPresent()) {
                this.iplocStats.incrementInsertedByCountryCodeCount();
                return Optional.of(new InetnumLocation(IsoCountriesUtils.getCountry(countryUppercase), ipRange, location.get(), network, countryUppercase));
            }
            if (attributes.containsKey("country") && (location2 = this.findLocation(attributes.get("country"), "")).isPresent()) {
                this.iplocStats.incrementInsertedByCountryCount();
                return Optional.of(new InetnumLocation(attributes.get("country"), ipRange, location2.get(), network, attributes.get("country")));
            }
            this.iplocStats.incrementNotInsertedCount();
            return Optional.empty();
        }
        catch (IOException | ParseException e) {
            return Optional.empty();
        }
    }

    private Optional<Location> findLocation(String searchTerms, String countryCode) throws IOException, ParseException {
        IndexSearcher indexSearcher = (IndexSearcher)this.searcherManager.acquire();
        Query geonamesQuery = new GeonamesQueryBuilder().queryText(searchTerms).countryCode(countryCode).build();
        TopDocs topDocs = indexSearcher.search(geonamesQuery, 1);
        if (topDocs.scoreDocs.length == 0) {
            return Optional.empty();
        }
        ScoreDoc scoreDoc = topDocs.scoreDocs[0];
        if (scoreDoc.score < 0.1f) {
            return Optional.empty();
        }
        Document document = indexSearcher.doc(scoreDoc.doc);
        double latitude = document.getField("latitude").numericValue().doubleValue();
        double longitude = document.getField("longitude").numericValue().doubleValue();
        return Optional.of(new Location(latitude, longitude));
    }

    private Optional<Location> stringToLocation(String geoloc) {
        String doubleRegex = "(\\d+\\.\\d+)";
        Pattern pattern = Pattern.compile("^" + doubleRegex + " " + doubleRegex + "$");
        Matcher matcher = pattern.matcher(geoloc);
        if (matcher.find()) {
            double latitude = Double.parseDouble(matcher.group(1));
            double longitude = Double.parseDouble(matcher.group(2));
            return Optional.of(new Location(latitude, longitude));
        }
        return Optional.empty();
    }

    public IpLocStats getIplocStats() {
        return this.iplocStats;
    }
}

