/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.iploc.nic;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.baremaps.iploc.nic.NicAttribute;

public class NicObject {
    private final List<NicAttribute> attributes;

    public NicObject(List<NicAttribute> attributes) {
        Preconditions.checkNotNull(attributes);
        Preconditions.checkArgument((!attributes.isEmpty() ? 1 : 0) != 0);
        this.attributes = attributes;
    }

    public String type() {
        return this.attributes.get(0).name();
    }

    public String id() {
        return this.attributes.get(0).value();
    }

    public List<NicAttribute> attributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public Optional<String> first(String name) {
        return this.attributes.stream().filter(attr -> attr.name().equals(name)).map(NicAttribute::value).findFirst();
    }

    public List<String> all(String name) {
        return this.attributes.stream().filter(attr -> attr.name().equals(name)).map(NicAttribute::value).toList();
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (NicAttribute attr : this.attributes()) {
            map.put(attr.name(), (String)(map.containsKey(attr.name()) ? (String)map.get(attr.name()) + ", " : "") + attr.value());
        }
        return map;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (NicAttribute attr : this.attributes()) {
            str.append(attr.name()).append(": ").append(attr.value()).append("\n");
        }
        return str.toString();
    }
}

