/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.geopackage;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.stream.Stream;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageManager;
import org.apache.baremaps.feature.ReadableAggregate;
import org.apache.baremaps.feature.Resource;
import org.apache.baremaps.storage.geopackage.GeoPackageTable;

public class GeoPackageDatabase
implements ReadableAggregate,
AutoCloseable {
    private final GeoPackage geoPackage;

    public GeoPackageDatabase(Path path) {
        this.geoPackage = GeoPackageManager.open((File)path.toFile());
    }

    @Override
    public Stream<Resource> read() throws IOException {
        return this.geoPackage.getFeatureTables().stream().map(table -> new GeoPackageTable(this.geoPackage.getFeatureDao(table)));
    }

    @Override
    public void close() throws Exception {
        this.geoPackage.close();
    }
}

