/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record DownloadUrl(String url, Path path, boolean replaceExisting) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(DownloadUrl.class);

    public DownloadUrl(String url, Path path) {
        this(url, path, false);
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        logger.info("Downloading {} to {}", (Object)this.url, (Object)this.path);
        URL targetUrl = new URL(this.url);
        Path targetPath = this.path.toAbsolutePath();
        if (Files.exists(targetPath, new LinkOption[0]) && !this.replaceExisting) {
            HttpURLConnection head = (HttpURLConnection)targetUrl.openConnection();
            HttpURLConnection.setFollowRedirects(true);
            head.setRequestMethod("HEAD");
            long contentLength = head.getContentLengthLong();
            head.disconnect();
            if (Files.size(targetPath) == contentLength) {
                logger.info("Skipping download of {} to {}", (Object)this.url, (Object)this.path);
                return;
            }
        }
        HttpURLConnection connection = (HttpURLConnection)targetUrl.openConnection();
        HttpURLConnection.setFollowRedirects(true);
        connection.setRequestMethod("GET");
        try (InputStream inputStream = connection.getInputStream();){
            Path downloadFile = targetPath.toAbsolutePath();
            Files.createDirectories(downloadFile.getParent(), new FileAttribute[0]);
            Files.copy(inputStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
            logger.info("Finished downloading {} to {}", (Object)this.url, (Object)this.path);
        }
    }
}

