/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.Objects;
import java.util.function.Supplier;

final class BeforeSubscriberPublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private final Supplier<? extends PublisherSource.Subscriber<? super T>> subscriberSupplier;

    BeforeSubscriberPublisher(Publisher<T> original, Supplier<? extends PublisherSource.Subscriber<? super T>> subscriberSupplier) {
        super(original);
        this.subscriberSupplier = Objects.requireNonNull(subscriberSupplier);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new BeforeSubscriberPublisherSubscriber<T>(subscriber, this.subscriberSupplier.get());
    }

    private static final class BeforeSubscriberPublisherSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> original;
        private final PublisherSource.Subscriber<? super T> subscriber;

        BeforeSubscriberPublisherSubscriber(PublisherSource.Subscriber<? super T> original, PublisherSource.Subscriber<? super T> subscriber) {
            this.original = original;
            this.subscriber = Objects.requireNonNull(subscriber);
        }

        public void onSubscribe(PublisherSource.Subscription s) {
            this.subscriber.onSubscribe(s);
            this.original.onSubscribe(s);
        }

        public void onNext(T t) {
            this.subscriber.onNext(t);
            this.original.onNext(t);
        }

        public void onComplete() {
            try {
                this.subscriber.onComplete();
            }
            catch (Throwable cause) {
                this.original.onError(cause);
                return;
            }
            this.original.onComplete();
        }

        public void onError(Throwable t) {
            try {
                this.subscriber.onError(t);
            }
            catch (Throwable cause) {
                this.original.onError(ThrowableUtils.addSuppressed((Throwable)t, (Throwable)cause));
                return;
            }
            this.original.onError(t);
        }
    }
}

