/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SimpleSingleSubscriber<T>
extends SequentialCancellable
implements SingleSource.Subscriber<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSingleSubscriber.class);
    private final Consumer<? super T> resultConsumer;

    SimpleSingleSubscriber(Consumer<? super T> resultConsumer) {
        this.resultConsumer = Objects.requireNonNull(resultConsumer);
    }

    public void onSubscribe(Cancellable cancellable) {
        this.nextCancellable(cancellable);
    }

    public void onSuccess(@Nullable T result) {
        this.resultConsumer.accept(result);
    }

    public void onError(Throwable t) {
        LOGGER.debug("Received exception from the source.", t);
    }
}

