package org.apache.baremaps.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.model.VectorLayer;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-03-14T17:37:24.176539752Z[Etc/UTC]")public class TileJSON   {
  
  private @Valid String tilejson;
  private @Valid String name;
  private @Valid String description;
  private @Valid String version;
  private @Valid String attribution;
  private @Valid String template;
  private @Valid String legend;
  private @Valid String scheme;
  private @Valid List<String> tiles = new ArrayList<String>();
  private @Valid List<String> grids = new ArrayList<String>();
  private @Valid List<String> data = new ArrayList<String>();
  private @Valid Integer minzoom;
  private @Valid Integer maxzoom;
  private @Valid List<Double> bounds = new ArrayList<Double>();
  private @Valid List<BigDecimal> center = new ArrayList<BigDecimal>();
  private @Valid List<VectorLayer> vectorLayers = new ArrayList<VectorLayer>();
  private @Valid Integer fillzoom;

  /**
   **/
  public TileJSON tilejson(String tilejson) {
    this.tilejson = tilejson;
    return this;
  }

  

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("tilejson")
  @NotNull
 @Pattern(regexp="\\d+\\.\\d+\\.\\d+\\w?[\\w\\d]*")  public String getTilejson() {
    return tilejson;
  }

  public void setTilejson(String tilejson) {
    this.tilejson = tilejson;
  }/**
   **/
  public TileJSON name(String name) {
    this.name = name;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }/**
   **/
  public TileJSON description(String description) {
    this.description = description;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }/**
   **/
  public TileJSON version(String version) {
    this.version = version;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("version")
 @Pattern(regexp="\\d+\\.\\d+\\.\\d+\\w?[\\w\\d]*")  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }/**
   **/
  public TileJSON attribution(String attribution) {
    this.attribution = attribution;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("attribution")
  public String getAttribution() {
    return attribution;
  }

  public void setAttribution(String attribution) {
    this.attribution = attribution;
  }/**
   **/
  public TileJSON template(String template) {
    this.template = template;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("template")
  public String getTemplate() {
    return template;
  }

  public void setTemplate(String template) {
    this.template = template;
  }/**
   **/
  public TileJSON legend(String legend) {
    this.legend = legend;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("legend")
  public String getLegend() {
    return legend;
  }

  public void setLegend(String legend) {
    this.legend = legend;
  }/**
   **/
  public TileJSON scheme(String scheme) {
    this.scheme = scheme;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("scheme")
  public String getScheme() {
    return scheme;
  }

  public void setScheme(String scheme) {
    this.scheme = scheme;
  }/**
   **/
  public TileJSON tiles(List<String> tiles) {
    this.tiles = tiles;
    return this;
  }

  

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("tiles")
  @NotNull
  public List<String> getTiles() {
    return tiles;
  }

  public void setTiles(List<String> tiles) {
    this.tiles = tiles;
  }/**
   **/
  public TileJSON grids(List<String> grids) {
    this.grids = grids;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("grids")
  public List<String> getGrids() {
    return grids;
  }

  public void setGrids(List<String> grids) {
    this.grids = grids;
  }/**
   **/
  public TileJSON data(List<String> data) {
    this.data = data;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("data")
  public List<String> getData() {
    return data;
  }

  public void setData(List<String> data) {
    this.data = data;
  }/**
   * minimum: 0
   * maximum: 30
   **/
  public TileJSON minzoom(Integer minzoom) {
    this.minzoom = minzoom;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("minzoom")
 @Min(0) @Max(30)  public Integer getMinzoom() {
    return minzoom;
  }

  public void setMinzoom(Integer minzoom) {
    this.minzoom = minzoom;
  }/**
   * minimum: 0
   * maximum: 30
   **/
  public TileJSON maxzoom(Integer maxzoom) {
    this.maxzoom = maxzoom;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("maxzoom")
 @Min(0) @Max(30)  public Integer getMaxzoom() {
    return maxzoom;
  }

  public void setMaxzoom(Integer maxzoom) {
    this.maxzoom = maxzoom;
  }/**
   **/
  public TileJSON bounds(List<Double> bounds) {
    this.bounds = bounds;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("bounds")
  public List<Double> getBounds() {
    return bounds;
  }

  public void setBounds(List<Double> bounds) {
    this.bounds = bounds;
  }/**
   **/
  public TileJSON center(List<BigDecimal> center) {
    this.center = center;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("center")
  public List<BigDecimal> getCenter() {
    return center;
  }

  public void setCenter(List<BigDecimal> center) {
    this.center = center;
  }/**
   **/
  public TileJSON vectorLayers(List<VectorLayer> vectorLayers) {
    this.vectorLayers = vectorLayers;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("vector_layers")
  public List<VectorLayer> getVectorLayers() {
    return vectorLayers;
  }

  public void setVectorLayers(List<VectorLayer> vectorLayers) {
    this.vectorLayers = vectorLayers;
  }/**
   **/
  public TileJSON fillzoom(Integer fillzoom) {
    this.fillzoom = fillzoom;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("fillzoom")
  public Integer getFillzoom() {
    return fillzoom;
  }

  public void setFillzoom(Integer fillzoom) {
    this.fillzoom = fillzoom;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TileJSON tileJSON = (TileJSON) o;
    return Objects.equals(this.tilejson, tileJSON.tilejson) &&
        Objects.equals(this.name, tileJSON.name) &&
        Objects.equals(this.description, tileJSON.description) &&
        Objects.equals(this.version, tileJSON.version) &&
        Objects.equals(this.attribution, tileJSON.attribution) &&
        Objects.equals(this.template, tileJSON.template) &&
        Objects.equals(this.legend, tileJSON.legend) &&
        Objects.equals(this.scheme, tileJSON.scheme) &&
        Objects.equals(this.tiles, tileJSON.tiles) &&
        Objects.equals(this.grids, tileJSON.grids) &&
        Objects.equals(this.data, tileJSON.data) &&
        Objects.equals(this.minzoom, tileJSON.minzoom) &&
        Objects.equals(this.maxzoom, tileJSON.maxzoom) &&
        Objects.equals(this.bounds, tileJSON.bounds) &&
        Objects.equals(this.center, tileJSON.center) &&
        Objects.equals(this.vectorLayers, tileJSON.vectorLayers) &&
        Objects.equals(this.fillzoom, tileJSON.fillzoom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tilejson, name, description, version, attribution, template, legend, scheme, tiles, grids, data, minzoom, maxzoom, bounds, center, vectorLayers, fillzoom);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TileJSON {\n");
    
    sb.append("    tilejson: ").append(toIndentedString(tilejson)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    attribution: ").append(toIndentedString(attribution)).append("\n");
    sb.append("    template: ").append(toIndentedString(template)).append("\n");
    sb.append("    legend: ").append(toIndentedString(legend)).append("\n");
    sb.append("    scheme: ").append(toIndentedString(scheme)).append("\n");
    sb.append("    tiles: ").append(toIndentedString(tiles)).append("\n");
    sb.append("    grids: ").append(toIndentedString(grids)).append("\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    minzoom: ").append(toIndentedString(minzoom)).append("\n");
    sb.append("    maxzoom: ").append(toIndentedString(maxzoom)).append("\n");
    sb.append("    bounds: ").append(toIndentedString(bounds)).append("\n");
    sb.append("    center: ").append(toIndentedString(center)).append("\n");
    sb.append("    vectorLayers: ").append(toIndentedString(vectorLayers)).append("\n");
    sb.append("    fillzoom: ").append(toIndentedString(fillzoom)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

