package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("link")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class Link   {
  private @Valid String href;
  private @Valid String rel;
  private @Valid String type;
  private @Valid Boolean templated;
  private @Valid String varBase;
  private @Valid String hreflang;
  private @Valid String title;
  private @Valid Integer length;

  /**
   * Supplies the URI to a remote resource (or resource fragment).
   **/
  public Link href(String href) {
    this.href = href;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Supplies the URI to a remote resource (or resource fragment).")
  @JsonProperty("href")
  @NotNull
  public String getHref() {
    return href;
  }

  @JsonProperty("href")
  public void setHref(String href) {
    this.href = href;
  }

  /**
   * The type or semantics of the relation.
   **/
  public Link rel(String rel) {
    this.rel = rel;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "The type or semantics of the relation.")
  @JsonProperty("rel")
  @NotNull
  public String getRel() {
    return rel;
  }

  @JsonProperty("rel")
  public void setRel(String rel) {
    this.rel = rel;
  }

  /**
   * A hint indicating what the media type of the result of dereferencing the link should be.
   **/
  public Link type(String type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(value = "A hint indicating what the media type of the result of dereferencing the link should be.")
  @JsonProperty("type")
  public String getType() {
    return type;
  }

  @JsonProperty("type")
  public void setType(String type) {
    this.type = type;
  }

  /**
   * This flag set to true if the link is a URL template.
   **/
  public Link templated(Boolean templated) {
    this.templated = templated;
    return this;
  }

  
  @ApiModelProperty(value = "This flag set to true if the link is a URL template.")
  @JsonProperty("templated")
  public Boolean getTemplated() {
    return templated;
  }

  @JsonProperty("templated")
  public void setTemplated(Boolean templated) {
    this.templated = templated;
  }

  /**
   * A base path to retrieve semantic information about the variables used in URL template.
   **/
  public Link varBase(String varBase) {
    this.varBase = varBase;
    return this;
  }

  
  @ApiModelProperty(value = "A base path to retrieve semantic information about the variables used in URL template.")
  @JsonProperty("varBase")
  public String getVarBase() {
    return varBase;
  }

  @JsonProperty("varBase")
  public void setVarBase(String varBase) {
    this.varBase = varBase;
  }

  /**
   * A hint indicating what the language of the result of dereferencing the link should be.
   **/
  public Link hreflang(String hreflang) {
    this.hreflang = hreflang;
    return this;
  }

  
  @ApiModelProperty(value = "A hint indicating what the language of the result of dereferencing the link should be.")
  @JsonProperty("hreflang")
  public String getHreflang() {
    return hreflang;
  }

  @JsonProperty("hreflang")
  public void setHreflang(String hreflang) {
    this.hreflang = hreflang;
  }

  /**
   * Used to label the destination of a link such that it can be used as a human-readable identifier.
   **/
  public Link title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "Used to label the destination of a link such that it can be used as a human-readable identifier.")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  @JsonProperty("title")
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   **/
  public Link length(Integer length) {
    this.length = length;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("length")
  public Integer getLength() {
    return length;
  }

  @JsonProperty("length")
  public void setLength(Integer length) {
    this.length = length;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Link link = (Link) o;
    return Objects.equals(this.href, link.href) &&
        Objects.equals(this.rel, link.rel) &&
        Objects.equals(this.type, link.type) &&
        Objects.equals(this.templated, link.templated) &&
        Objects.equals(this.varBase, link.varBase) &&
        Objects.equals(this.hreflang, link.hreflang) &&
        Objects.equals(this.title, link.title) &&
        Objects.equals(this.length, link.length);
  }

  @Override
  public int hashCode() {
    return Objects.hash(href, rel, type, templated, varBase, hreflang, title, length);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Link {\n");
    
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    rel: ").append(toIndentedString(rel)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    templated: ").append(toIndentedString(templated)).append("\n");
    sb.append("    varBase: ").append(toIndentedString(varBase)).append("\n");
    sb.append("    hreflang: ").append(toIndentedString(hreflang)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    length: ").append(toIndentedString(length)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

